/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.daisy.config;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.daisy.config.key.DaisyConfigKey;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DaisyConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"DaisyConfig");
    private final String modName;
    private final File configFile;
    private final Object2ObjectOpenHashMap<String, DaisyConfigKey<Object>> configKeys = new Object2ObjectOpenHashMap();
    private final Map<String, Object> configs = new Object2ObjectOpenHashMap();

    public DaisyConfig(String modName, Consumer<DaisyConfig> register) {
        this.modName = modName;
        this.configFile = new File("config/" + modName + ".json");
        register.accept(this);
    }

    public <X> void register(String key, X defaultValue) {
        this.configKeys.put((Object)key, DaisyConfigKey.create(key, defaultValue));
    }

    public <X> void register(DaisyConfigKey<X> configKey) {
        this.configKeys.put((Object)configKey.name(), configKey);
    }

    public <X> void setConfig(DaisyConfigKey<X> configKey, X value) {
        this.configs.put(configKey.name(), value);
        configKey.triggerChangeAction();
    }

    public <X> void setConfigFromMap(DaisyConfigKey<X> configKey, Map<String, JsonElement> map) {
        map.forEach((key, value) -> this.configs.put(configKey.name(), this.getConfig(configKey, map)));
    }

    private <X> X getConfig(DaisyConfigKey<X> configKey, Map<String, JsonElement> map) {
        JsonElement result = map.get(configKey.name());
        if (result == null) {
            return configKey.value();
        }
        return (X)result;
    }

    public <X> X getConfig(@NotNull DaisyConfigKey<X> configKey) {
        Object value = this.configs.get(configKey.name());
        if (value == null) {
            return configKey.value();
        }
        return (X)value;
    }

    public void load() {
        this.loadAsDefault();
        try {
            Map<String, JsonElement> config = this.toMap(IOUtil.read(new FileReader(this.configFile, StandardCharsets.UTF_8)));
            for (DaisyConfigKey configKey : this.configKeys.values()) {
                this.setConfigFromMap(configKey, config);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Config not found, will use default config values", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("Happening unexpected exception, config system cannot resolve it, will use default config values", (Throwable)e);
        }
        this.write();
    }

    public <X> DaisyConfigKey<X> getConfigKey(String name) {
        return (DaisyConfigKey)this.configKeys.get((Object)name);
    }

    public Map<String, JsonElement> toMap(String data) {
        Map jsonMap = GsonHelper.parse((String)data).asMap();
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        return Catheter.of(jsonMap.entrySet()).varyMap(map, (identity, entry) -> identity.put((String)entry.getKey(), (JsonElement)entry.getValue()));
    }

    public void write() {
        try {
            if (!this.configFile.getParentFile().exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            JsonObject json = new JsonObject();
            for (Map.Entry<String, Object> entry : this.configs.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    String string = (String)value;
                    json.addProperty(entry.getKey(), string);
                    continue;
                }
                if (value instanceof Number) {
                    Number number = (Number)value;
                    json.addProperty(entry.getKey(), number);
                    continue;
                }
                if (!(value instanceof Character)) continue;
                Character bool = (Character)value;
                json.addProperty(entry.getKey(), bool);
            }
            IOUtil.write((Writer)new FileWriter(this.configFile, StandardCharsets.UTF_8), json.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public void loadAsDefault() {
        this.configKeys.values().forEach(key -> this.setConfig((DaisyConfigKey)key, (Object)key.value()));
    }

    public void copyFrom(@NotNull DaisyConfig config) {
        this.configKeys.values().forEach(key -> this.setConfig((DaisyConfigKey)key, config.getConfig((DaisyConfigKey)key)));
    }

    public void print() {
        this.configs.forEach((name, value) -> LOGGER.info("Config '{}' in mod '{}' is '{}'", name, (Object)this.modName, value));
    }

    public Map<String, ?> collect() {
        HashMap configs = CollectionFactor.hashMap();
        this.configKeys.forEach((key, value) -> configs.put(key, this.getConfig((DaisyConfigKey)value)));
        return configs;
    }
}

