/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.lilium.mathematic;

import com.github.cao.awa.catheter.Catheter;
import java.math.BigInteger;
import java.util.Comparator;
import org.jetbrains.annotations.Range;

public class Mathematics {
    @SafeVarargs
    public static <T extends Number> T catheterMax(T ... targets) {
        return (T)Catheter.of(targets).max(Comparator.comparingDouble(Number::doubleValue));
    }

    @SafeVarargs
    public static <T extends Number> T forMax(T ... targets) {
        T max = targets[0];
        for (T t : targets) {
            if (!(((Number)t).doubleValue() > ((Number)max).doubleValue())) continue;
            max = t;
        }
        return max;
    }

    public static String radix(byte[] data, @Range(from=2L, to=36L) int radix) {
        if (data.length == 0) {
            return "0";
        }
        return new BigInteger(data).toString(radix);
    }

    public static String radix(String data, @Range(from=2L, to=36L) int sourceRadix, @Range(from=2L, to=36L) int toRadix) {
        if (data.isEmpty()) {
            return "0";
        }
        return new BigInteger(data, sourceRadix).toString(toRadix);
    }

    public static byte[] toBytes(BigInteger integer) {
        return integer.toByteArray();
    }

    public static byte[] toBytes(String value, @Range(from=2L, to=36L) int radix) {
        return new BigInteger(value, radix).toByteArray();
    }

    public static boolean isOdd(long number) {
        return (number & 1L) == 1L;
    }
}

