/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.trashelemental.dracolotl.datagen.ModAdvancementProvider;
import net.trashelemental.dracolotl.datagen.ModBlockStateProvider;
import net.trashelemental.dracolotl.datagen.ModGlobalLootModifiersProvider;
import net.trashelemental.dracolotl.datagen.ModItemModelProvider;
import net.trashelemental.dracolotl.datagen.ModRecipeProvider;
import net.trashelemental.dracolotl.datagen.loot.ModLootTableProvider;
import net.trashelemental.dracolotl.datagen.tags.ModBlockTagGenerator;
import net.trashelemental.dracolotl.datagen.tags.ModEntityTagGenerator;
import net.trashelemental.dracolotl.datagen.tags.ModItemTagGenerator;

@Mod.EventBusSubscriber(modid="dracolotl", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

