/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.entity.custom;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.trashelemental.dracolotl.dracolotl;
import net.trashelemental.dracolotl.item.ModItems;
import net.trashelemental.dracolotl.util.ModBucketableInterface;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DracolotlEntity
extends TamableAnimal
implements GeoEntity,
ModBucketableInterface {
    private static final EntityDataAccessor<Boolean> DATA_PLAYING_DEAD = SynchedEntityData.m_135353_(DracolotlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(DracolotlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double GROUND_SPEED = 0.15;
    private static final double AIR_SPEED = 0.6;
    public String BEHAVIOR = "WANDER";
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public DracolotlEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PLAYING_DEAD, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean m_8036_() {
                return super.m_8036_() && DracolotlEntity.follow(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean m_8036_() {
                return super.m_8036_() && DracolotlEntity.follow(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            public boolean m_8036_() {
                return super.m_8036_() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return super.m_8036_() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, true){

            public boolean m_8036_() {
                return super.m_8036_() && DracolotlEntity.follow(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42545_}), false){

            public boolean m_8036_() {
                return super.m_8036_() && DracolotlEntity.wander(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && DracolotlEntity.wander(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean m_8036_() {
                return super.m_8036_() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
    }

    public static boolean follow(DracolotlEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isFollowing();
    }

    public static boolean wander(DracolotlEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isWandering();
    }

    public static boolean playingDead(DracolotlEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isPlayingDead();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22280_, 0.6);
    }

    protected PathNavigation m_6037_(Level p_level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_level){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isFlying() || this.m_20069_() || this.m_20077_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.6);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.15);
        }
        super.m_7023_(travelVector);
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.BUCKET_OF_DRACOLOTL.get());
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.f_144077_;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromBucket();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.fromBucket() && !this.m_8077_() && !this.m_21824_();
    }

    @Override
    public boolean fromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    @Override
    public void saveToBucketTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ModBucketableInterface.saveDefaultDataToBucketTag((Mob)this, stack);
        if (this.m_21824_()) {
            tag.m_128379_("IsTame", true);
            if (this.m_21805_() != null) {
                tag.m_128362_("OwnerUUID", this.m_21805_());
            }
        }
    }

    @Override
    public void loadFromBucketTag(CompoundTag tag) {
        ModBucketableInterface.loadDefaultDataFromBucketTag(this, tag);
        if (tag.m_128441_("IsTame")) {
            this.m_7105_(tag.m_128471_("IsTame"));
        }
        if (tag.m_128441_("OwnerUUID")) {
            this.m_21816_(tag.m_128342_("OwnerUUID"));
        }
        if (this.m_21824_()) {
            this.BEHAVIOR = "FOLLOW";
        }
    }

    public void setPlayingDead(boolean playingDead) {
        this.f_19804_.m_135381_(DATA_PLAYING_DEAD, (Object)playingDead);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYING_DEAD);
    }

    public boolean m_142066_() {
        return !this.isPlayingDead() && super.m_142066_();
    }

    public boolean m_21040_(LivingEntity livingentity, TargetingConditions condition) {
        return !this.isPlayingDead();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.m_21223_() - amount <= 8.0f && !this.isPlayingDead()) {
            this.setPlayingDead(true);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 3));
            dracolotl.queueServerWork(200, () -> {
                if (this.m_6084_()) {
                    LivingEntity patt11707$temp;
                    this.setPlayingDead(false);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 1));
                    if (this.m_21824_() && (patt11707$temp = this.m_269323_()) instanceof Player) {
                        Player owner = (Player)patt11707$temp;
                        owner.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 1));
                    }
                }
            });
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.isPlayingDead()) {
            target = null;
        }
        super.m_6710_(target);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isPlayingDead()) {
            List nearbyEntities = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(10.0));
            for (Mob entity : nearbyEntities) {
                if (entity.m_5448_() != this) continue;
                entity.m_6710_(null);
            }
        }
        if (this.isPlayingDead() || !this.isWandering() && !this.isFollowing()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.5, 0.0));
        }
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_144064_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_144063_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_6040_() {
        return true;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41720_() == Items.f_42545_) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (!this.m_21824_()) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_21828_(pPlayer);
                    this.BEHAVIOR = "FOLLOW";
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
        } else {
            if (itemstack.m_41720_() == Items.f_42590_ && this.m_21830_((LivingEntity)pPlayer)) {
                if (!pPlayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                ItemStack dragonsBreath = new ItemStack((ItemLike)Items.f_42735_);
                if (!pPlayer.m_150109_().m_36054_(dragonsBreath)) {
                    pPlayer.m_36176_(dragonsBreath, false);
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11771_, SoundSource.NEUTRAL, 0.5f, 3.0f);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42003_) {
                if (this.m_9236_().f_46441_.m_188503_(100) < 3) {
                    ItemStack dragonEgg = new ItemStack((ItemLike)Items.f_42104_);
                    this.m_19983_(dragonEgg);
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                for (int i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (this.m_9236_().f_46441_.m_188500_() - 0.5), this.m_20186_() + 0.5, this.m_20189_() + (this.m_9236_().f_46441_.m_188500_() - 0.5), 0.0, 0.0, 0.0);
                }
                if (!pPlayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42446_) {
                if (!this.m_21824_() || this.m_21830_((LivingEntity)pPlayer)) {
                    ModBucketableInterface.bucketMobPickup(pPlayer, pHand, this);
                }
            } else {
                InteractionResult retval = super.m_6071_(pPlayer, pHand);
                if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                    this.m_21530_();
                }
                if (this.m_21830_((LivingEntity)pPlayer)) {
                    this.cycleBehavior(pPlayer);
                    return InteractionResult.SUCCESS;
                }
                return retval;
            }
        }
        return InteractionResult.PASS;
    }

    private void setBehaviorInPersistentData(String behavior) {
        CompoundTag tag = this.getPersistentData();
        tag.m_128359_("Behavior", behavior);
    }

    public boolean isFollowing() {
        return this.BEHAVIOR.equals("FOLLOW");
    }

    public boolean isWandering() {
        return this.BEHAVIOR.equals("WANDER");
    }

    private void cycleBehavior(Player pPlayer) {
        switch (this.BEHAVIOR) {
            case "FOLLOW": {
                this.BEHAVIOR = "WANDER";
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Dracolotl will wander"), true);
                break;
            }
            case "STAY": {
                this.BEHAVIOR = "FOLLOW";
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Dracolotl will follow"), true);
                break;
            }
            case "WANDER": {
                this.BEHAVIOR = "STAY";
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Dracolotl will stay"), true);
            }
        }
        this.setBehaviorInPersistentData(this.BEHAVIOR);
    }

    public boolean ShouldUseRedDragonSkin() {
        return this.m_8077_() && "Hellkite".equals(this.m_7770_().getString());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Behavior", this.BEHAVIOR);
        compound.m_128379_("FromBucket", this.fromBucket());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Behavior")) {
            this.BEHAVIOR = compound.m_128461_("Behavior");
            this.setFromBucket(compound.m_128471_("FromBucket"));
        }
    }

    public boolean isFlying() {
        return !this.m_20096_() && !this.isPlayingDead();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.isPlayingDead()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("PLAY_DEAD", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFlying() && !this.m_21525_()) {
            if (geoAnimatableAnimationState.isMoving()) {
                geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("MOVE_AIR", Animation.LoopType.LOOP));
            } else {
                geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("IDLE_AIR", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("MOVE_GROUND", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("IDLE_GROUND", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

