/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.item.custom;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.trashelemental.dracolotl.entity.custom.DracolotlEntity;

public class DracolotlBucketItem
extends Item {
    private final Supplier<? extends EntityType<?>> typeSupplier;
    private final Supplier<SoundEvent> emptySoundSupplier;

    public DracolotlBucketItem(Supplier<? extends EntityType<?>> typeSupplier, Supplier<SoundEvent> emptySoundSupplier, Item.Properties properties) {
        super(properties);
        this.typeSupplier = typeSupplier;
        this.emptySoundSupplier = emptySoundSupplier;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        level.m_5594_(player, pos, this.emptySoundSupplier.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel serverLevel, ItemStack bucketedMobStack, BlockPos pos) {
        Entity entity = this.typeSupplier.get().m_20592_(serverLevel, bucketedMobStack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof DracolotlEntity) {
            DracolotlEntity dracolotl2 = (DracolotlEntity)entity;
            CompoundTag tag = bucketedMobStack.m_41783_();
            if (tag != null) {
                dracolotl2.loadFromBucketTag(tag);
                dracolotl2.setFromBucket(true);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = context.m_43722_();
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockState = level.m_8055_(blockPos);
        BlockPos spawnPos = blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_121945_(direction);
        if (!level.m_8055_(spawnPos).m_60795_()) {
            return InteractionResult.FAIL;
        }
        this.spawn((ServerLevel)level, itemStack, spawnPos);
        this.playEmptySound(player, (LevelAccessor)level, blockPos);
        if (!player.m_7500_()) {
            itemStack.m_41774_(1);
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42446_));
        }
        level.m_142346_((Entity)player, GameEvent.f_157810_, blockPos);
        return InteractionResult.CONSUME;
    }
}

