/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.junkyard_lib.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TamableEntity
extends TamableAnimal {
    private final Item tameItem;
    private final Item breedItem;
    public String BEHAVIOR = "WANDER";
    String entityName = this.getEntityName();

    public TamableEntity(EntityType<? extends TamableAnimal> entityType, Level level, Item tameItem, Item breedItem) {
        super(entityType, level);
        this.tameItem = tameItem;
        this.breedItem = breedItem;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean m_8036_() {
                return super.m_8036_() && !TamableEntity.stay(TamableEntity.this);
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean m_8036_() {
                return super.m_8036_() && TamableEntity.follow(TamableEntity.this);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return super.m_8036_() && TamableEntity.wander(TamableEntity.this);
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.tameItem}), false){

            public boolean m_8036_() {
                return super.m_8036_() && !TamableEntity.isTame(TamableEntity.this);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.breedItem}), false){

            public boolean m_8036_() {
                return super.m_8036_() && !TamableEntity.stay(TamableEntity.this);
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !TamableEntity.stay(TamableEntity.this);
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && TamableEntity.wander(TamableEntity.this);
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static boolean follow(TamableEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isFollowing();
    }

    public static boolean wander(TamableEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isWandering();
    }

    public static boolean stay(TamableEntity entity) {
        return !TamableEntity.follow(entity) && !TamableEntity.wander(entity);
    }

    public static boolean isTame(TamableEntity entity) {
        return entity.m_21824_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_144064_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_144063_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(this.breedItem);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(this.tameItem)) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (!this.m_21824_()) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_21828_(pPlayer);
                    this.BEHAVIOR = "FOLLOW";
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
        } else {
            InteractionResult retval = super.m_6071_(pPlayer, pHand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
            if (this.m_21830_((LivingEntity)pPlayer)) {
                this.cycleBehavior(pPlayer);
                return InteractionResult.SUCCESS;
            }
            return retval;
        }
        return InteractionResult.PASS;
    }

    private void setBehaviorInPersistentData(String behavior) {
        CompoundTag tag = this.getPersistentData();
        tag.m_128359_("Behavior", behavior);
    }

    public boolean isFollowing() {
        return this.BEHAVIOR.equals("FOLLOW");
    }

    public boolean isWandering() {
        return this.BEHAVIOR.equals("WANDER");
    }

    private void cycleBehavior(Player pPlayer) {
        switch (this.BEHAVIOR) {
            case "FOLLOW": {
                this.BEHAVIOR = "WANDER";
                pPlayer.m_5661_((Component)Component.m_237113_((String)(this.entityName + " will wander")), true);
                break;
            }
            case "STAY": {
                this.BEHAVIOR = "FOLLOW";
                pPlayer.m_5661_((Component)Component.m_237113_((String)(this.entityName + " will follow")), true);
                break;
            }
            case "WANDER": {
                this.BEHAVIOR = "STAY";
                pPlayer.m_5661_((Component)Component.m_237113_((String)(this.entityName + " will stay")), true);
            }
        }
        this.setBehaviorInPersistentData(this.BEHAVIOR);
    }

    public String getEntityName() {
        if (this.m_8077_()) {
            return this.m_7770_().getString();
        }
        return this.m_6095_().m_20676_().getString();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Behavior", this.BEHAVIOR);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Behavior")) {
            this.BEHAVIOR = compound.m_128461_("Behavior");
        }
    }
}

