/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.util.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.trashelemental.dracolotl.dracolotl;
import net.trashelemental.dracolotl.entity.ModEntities;
import net.trashelemental.dracolotl.entity.custom.DracolotlEntity;

@Mod.EventBusSubscriber(modid="dracolotl")
public class SummonDracolotlEvent {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("dracolotl:dragon_eggs"))) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.m_7918_(-2, -2, 0)) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.m_7918_(2, -2, 0)) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.m_7918_(0, -2, -2)) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.m_7918_(0, -2, 2))) {
            event.setCanceled(true);
            SummonDracolotlEvent.setCrystalBeams(level, pos);
            level.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7471_(pos, false);
            dracolotl.queueServerWork(40, () -> {
                SummonDracolotlEvent.removeEndCrystals(level, pos.m_7918_(-2, -2, 0));
                level.m_5594_(null, pos.m_7918_(-2, -2, 0), SoundEvents.f_11892_, SoundSource.BLOCKS, 1.0f, 1.0f);
                dracolotl.queueServerWork(20, () -> {
                    SummonDracolotlEvent.removeEndCrystals(level, pos.m_7918_(2, -2, 0));
                    level.m_5594_(null, pos.m_7918_(2, -2, 0), SoundEvents.f_11892_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    dracolotl.queueServerWork(20, () -> {
                        SummonDracolotlEvent.removeEndCrystals(level, pos.m_7918_(0, -2, -2));
                        level.m_5594_(null, pos.m_7918_(0, -2, -2), SoundEvents.f_11892_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        dracolotl.queueServerWork(20, () -> {
                            SummonDracolotlEvent.removeEndCrystals(level, pos.m_7918_(0, -2, 2));
                            level.m_5594_(null, pos, SoundEvents.f_11890_, SoundSource.BLOCKS, 1.0f, 2.0f);
                            SummonDracolotlEvent.spawnTamedDracolotl(level, pos, player);
                        });
                    });
                });
            });
        }
    }

    private static boolean isEndCrystalNearby(Level level, BlockPos pos) {
        return !level.m_45976_(EndCrystal.class, new AABB(pos)).isEmpty();
    }

    private static void removeEndCrystals(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            List crystals = level.m_45976_(EndCrystal.class, new AABB(pos));
            for (EndCrystal crystal : crystals) {
                crystal.m_146870_();
                SummonDracolotlEvent.sendParticlePacket(level, (ParticleOptions)ParticleTypes.f_123813_, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_(), 5);
            }
        }
    }

    private static void spawnTamedDracolotl(Level level, BlockPos pos, Player player) {
        DracolotlEntity dracolotl2;
        if (!level.f_46443_ && (dracolotl2 = (DracolotlEntity)((EntityType)ModEntities.DRACOLOTL.get()).m_20615_(level)) != null) {
            dracolotl2.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            dracolotl2.m_7105_(true);
            dracolotl2.m_21816_(player.m_20148_());
            dracolotl2.BEHAVIOR = "FOLLOW";
            level.m_7967_((Entity)dracolotl2);
            SummonDracolotlEvent.sendParticlePacket(level, (ParticleOptions)ParticleTypes.f_123799_, dracolotl2.m_20185_(), dracolotl2.m_20186_(), dracolotl2.m_20189_(), 20);
        }
    }

    private static void sendParticlePacket(Level level, ParticleOptions particleType, double x, double y, double z, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(particleType, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static void setCrystalBeams(Level level, BlockPos eggPos) {
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.m_7918_(-2, -2, 0), eggPos);
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.m_7918_(2, -2, 0), eggPos);
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.m_7918_(0, -2, -2), eggPos);
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.m_7918_(0, -2, 2), eggPos);
    }

    private static void setCrystalBeamTarget(Level level, BlockPos crystalPos, BlockPos eggPos) {
        List crystals = level.m_45976_(EndCrystal.class, new AABB(crystalPos).m_82400_(1.0));
        for (EndCrystal crystal : crystals) {
            crystal.m_31052_(eggPos);
        }
    }
}

