/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.trashelemental.dracolotl.datagen.ModAdvancementProvider;
import net.trashelemental.dracolotl.datagen.ModBlockStateProvider;
import net.trashelemental.dracolotl.datagen.ModItemModelProvider;
import net.trashelemental.dracolotl.datagen.ModRecipeProvider;
import net.trashelemental.dracolotl.datagen.tags.ModBlockTagGenerator;
import net.trashelemental.dracolotl.datagen.tags.ModEntityTagGenerator;
import net.trashelemental.dracolotl.datagen.tags.ModItemTagGenerator;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="dracolotl")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(output, lookupProvider, blockTagGenerator.contentsGetter()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTagGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(output, lookupProvider, existingFileHelper));
    }
}

