/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.item.custom;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.trashelemental.dracolotl.entity.custom.DracolotlEntity;

public class DracolotlBucketItem
extends Item {
    private final EntityType<?> type;
    private final SoundEvent emptySound;

    public DracolotlBucketItem(EntityType<?> type, SoundEvent emptySound, Item.Properties properties) {
        super(properties);
        this.type = type;
        this.emptySound = emptySound;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        level.playSound(player, pos, this.emptySound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel serverLevel, ItemStack bucketedMobStack, BlockPos pos) {
        Entity entity = this.type.spawn(serverLevel, bucketedMobStack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof DracolotlEntity) {
            DracolotlEntity dracolotl2 = (DracolotlEntity)entity;
            CustomData customData = (CustomData)bucketedMobStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            dracolotl2.loadFromBucketTag(customData.copyTag());
            dracolotl2.setFromBucket(true);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = context.getItemInHand();
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockState = level.getBlockState(blockPos);
        BlockPos spawnPos = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
        if (!level.getBlockState(spawnPos).isAir()) {
            return InteractionResult.FAIL;
        }
        this.spawn((ServerLevel)level, itemStack, spawnPos);
        this.playEmptySound(player, (LevelAccessor)level, blockPos);
        if (!player.isCreative()) {
            itemStack.shrink(1);
            player.getInventory().add(new ItemStack((ItemLike)Items.BUCKET));
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, blockPos);
        return InteractionResult.CONSUME;
    }
}

