/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.entity.custom;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.trashelemental.dracolotl.dracolotl;
import net.trashelemental.dracolotl.item.ModItems;
import net.trashelemental.dracolotl.util.ModBucketableInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DracolotlEntity
extends TamableAnimal
implements GeoEntity,
ModBucketableInterface {
    private static final EntityDataAccessor<Boolean> DATA_PLAYING_DEAD = SynchedEntityData.defineId(DracolotlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(DracolotlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final double GROUND_SPEED = 0.15;
    private static final double AIR_SPEED = 0.6;
    public String BEHAVIOR = "WANDER";
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public DracolotlEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PLAYING_DEAD, (Object)false);
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                return super.canUse() && DracolotlEntity.follow(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                return super.canUse() && DracolotlEntity.follow(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            public boolean canUse() {
                return super.canUse() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                return super.canUse() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                return super.canUse() && DracolotlEntity.follow(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_EYE}), false){

            public boolean canUse() {
                return super.canUse() && DracolotlEntity.wander(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && DracolotlEntity.wander(DracolotlEntity.this) && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                return super.canUse() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && !DracolotlEntity.playingDead(DracolotlEntity.this);
            }
        });
    }

    public static boolean follow(DracolotlEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isFollowing();
    }

    public static boolean wander(DracolotlEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isWandering();
    }

    public static boolean playingDead(DracolotlEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isPlayingDead();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 4.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FLYING_SPEED, 0.6);
    }

    protected PathNavigation createNavigation(Level p_level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation(this, (Mob)this, p_level){

            public boolean isStableDestination(BlockPos p_27947_) {
                return !this.level.getBlockState(p_27947_.below()).isAir();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public void travel(Vec3 travelVector) {
        if (this.isFlying() || this.isInLiquid() || this.isInLava()) {
            Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.6);
        } else {
            Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.15);
        }
        super.travel(travelVector);
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.BUCKET_OF_DRACOLOTL.get());
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.fromBucket() && !this.hasCustomName() && !this.isTame();
    }

    @Override
    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    @Override
    public void saveToBucketTag(ItemStack stack) {
        ModBucketableInterface.saveDefaultDataToBucketTag(this, stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, data -> {
            if (this.isTame()) {
                data.putBoolean("IsTame", true);
                if (this.getOwnerUUID() != null) {
                    data.putUUID("OwnerUUID", this.getOwnerUUID());
                }
            }
        });
    }

    @Override
    public void loadFromBucketTag(CompoundTag tag) {
        ModBucketableInterface.loadDefaultDataFromBucketTag(this, tag);
        if (tag.contains("IsTame")) {
            this.setTame(tag.getBoolean("IsTame"), false);
        }
        if (tag.contains("OwnerUUID")) {
            this.setOwnerUUID(tag.getUUID("OwnerUUID"));
        }
        if (this.isTame()) {
            this.BEHAVIOR = "FOLLOW";
        }
    }

    public void setPlayingDead(boolean playingDead) {
        this.entityData.set(DATA_PLAYING_DEAD, (Object)playingDead);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.entityData.get(DATA_PLAYING_DEAD);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isPlayingDead() && super.canBeSeenAsEnemy();
    }

    public boolean canAttack(LivingEntity livingentity, TargetingConditions condition) {
        return !this.isPlayingDead();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL) || source.is(DamageTypes.CAMPFIRE) || source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.FIREBALL) || source.is(DamageTypes.UNATTRIBUTED_FIREBALL) || source.is(DamageTypes.LAVA) || source.is(DamageTypes.HOT_FLOOR) || source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (!this.level().isClientSide && this.getHealth() - amount <= 8.0f && !this.isPlayingDead()) {
            this.setPlayingDead(true);
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 3));
            dracolotl.queueServerWork(200, () -> {
                if (this.isAlive()) {
                    LivingEntity patt0$temp;
                    this.setPlayingDead(false);
                    this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 100, 1));
                    if (this.isTame() && (patt0$temp = this.getOwner()) instanceof Player) {
                        Player owner = (Player)patt0$temp;
                        owner.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 100, 1));
                    }
                }
            });
            return true;
        }
        return super.hurt(source, amount);
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (this.isPlayingDead()) {
            target = null;
        }
        super.setTarget(target);
    }

    public void tick() {
        super.tick();
        if (this.isPlayingDead()) {
            List nearbyEntities = this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(10.0));
            for (Mob entity : nearbyEntities) {
                if (entity.getTarget() != this) continue;
                entity.setTarget(null);
            }
        }
        if (this.isPlayingDead() || !this.isWandering() && !this.isFollowing()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.5, 0.0));
        }
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.AXOLOTL_IDLE_AIR;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return SoundEvents.AXOLOTL_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.AXOLOTL_DEATH;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.getItem() == Items.ENDER_EYE) {
            this.usePlayerItem(pPlayer, pHand, itemstack);
            if (!this.isTame()) {
                if (this.random.nextInt(5) == 0) {
                    this.tame(pPlayer);
                    this.BEHAVIOR = "FOLLOW";
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                this.setPersistenceRequired();
                return InteractionResult.SUCCESS;
            }
        } else {
            if (itemstack.getItem() == Items.GLASS_BOTTLE && this.isOwnedBy((LivingEntity)pPlayer)) {
                if (!pPlayer.isCreative()) {
                    itemstack.shrink(1);
                }
                ItemStack dragonsBreath = new ItemStack((ItemLike)Items.DRAGON_BREATH);
                if (!pPlayer.getInventory().add(dragonsBreath)) {
                    pPlayer.drop(dragonsBreath, false);
                }
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.NEUTRAL, 0.5f, 3.0f);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() == Items.CHORUS_FLOWER) {
                if (this.level().random.nextInt(100) < 3) {
                    ItemStack dragonEgg = new ItemStack((ItemLike)Items.DRAGON_EGG);
                    this.spawnAtLocation(dragonEgg);
                }
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EAT, SoundSource.NEUTRAL, 0.5f, 1.0f);
                for (int i = 0; i < 5; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (this.level().random.nextDouble() - 0.5), this.getY() + 0.5, this.getZ() + (this.level().random.nextDouble() - 0.5), 0.0, 0.0, 0.0);
                }
                if (!pPlayer.isCreative()) {
                    itemstack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() == Items.BUCKET) {
                if (!this.isTame() || this.isOwnedBy((LivingEntity)pPlayer)) {
                    ModBucketableInterface.bucketMobPickup(pPlayer, pHand, this);
                }
            } else {
                InteractionResult retval = super.mobInteract(pPlayer, pHand);
                if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                    this.setPersistenceRequired();
                }
                if (this.isOwnedBy((LivingEntity)pPlayer)) {
                    this.cycleBehavior(pPlayer);
                    return InteractionResult.SUCCESS;
                }
                return retval;
            }
        }
        return InteractionResult.PASS;
    }

    private void setBehaviorInPersistentData(String behavior) {
        CompoundTag tag = this.getPersistentData();
        tag.putString("Behavior", behavior);
    }

    public boolean isFollowing() {
        return this.BEHAVIOR.equals("FOLLOW");
    }

    public boolean isWandering() {
        return this.BEHAVIOR.equals("WANDER");
    }

    private void cycleBehavior(Player pPlayer) {
        switch (this.BEHAVIOR) {
            case "FOLLOW": {
                this.BEHAVIOR = "WANDER";
                pPlayer.displayClientMessage((Component)Component.literal((String)"Dracolotl will wander"), true);
                break;
            }
            case "STAY": {
                this.BEHAVIOR = "FOLLOW";
                pPlayer.displayClientMessage((Component)Component.literal((String)"Dracolotl will follow"), true);
                break;
            }
            case "WANDER": {
                this.BEHAVIOR = "STAY";
                pPlayer.displayClientMessage((Component)Component.literal((String)"Dracolotl will stay"), true);
            }
        }
        this.setBehaviorInPersistentData(this.BEHAVIOR);
    }

    public boolean ShouldUseRedDragonSkin() {
        return this.hasCustomName() && "Hellkite".equals(this.getCustomName().getString());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Behavior", this.BEHAVIOR);
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Behavior")) {
            this.BEHAVIOR = compound.getString("Behavior");
            this.setFromBucket(compound.getBoolean("FromBucket"));
        }
    }

    public boolean isFlying() {
        return !this.onGround() && !this.isPlayingDead();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate));
    }

    private PlayState predicate(AnimationState<DracolotlEntity> dracolotlEntityAnimationState) {
        if (this.isPlayingDead()) {
            dracolotlEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("PLAY_DEAD", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFlying() && !this.isNoAi()) {
            if (dracolotlEntityAnimationState.isMoving()) {
                dracolotlEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("MOVE_AIR", Animation.LoopType.LOOP));
            } else {
                dracolotlEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("IDLE_AIR", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        if (dracolotlEntityAnimationState.isMoving()) {
            dracolotlEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("MOVE_GROUND", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        dracolotlEntityAnimationState.getController().setAnimation(RawAnimation.begin().then("IDLE_GROUND", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

