/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.junkyard_lib.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.trashelemental.dracolotl.junkyard_lib.visual.particle.ParticleMethods;
import org.jetbrains.annotations.Nullable;

public class MinionEntity
extends TamableAnimal {
    private boolean isPersistent = false;
    private final ParticleOptions particles;
    private final SoundEvent DespawnSound;
    private int lifespan = 300;

    public MinionEntity(EntityType<? extends TamableAnimal> entityType, Level level, ParticleOptions particles, SoundEvent despawnSound) {
        super(entityType, level);
        this.particles = particles;
        this.DespawnSound = despawnSound;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static boolean isTame(MinionEntity entity) {
        return entity.isTame();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.AXOLOTL_IDLE_AIR;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return SoundEvents.AXOLOTL_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.AXOLOTL_DEATH;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean shouldDropExperience() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        Entity entity = pSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.getOwnerUUID() != null && this.getOwnerUUID().equals(attacker.getUUID())) {
                return attacker.isCrouching();
            }
        }
        return super.hurt(pSource, pAmount);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        ParticleMethods.ParticlesAround(this.level(), this.particles, (Entity)this, 10, 0.5);
    }

    public void setLifespan(int lifespan, boolean isPersistent) {
        this.lifespan = lifespan;
        this.isPersistent = isPersistent;
    }

    public void tick() {
        super.tick();
        if (!this.isPersistent) {
            if (this.lifespan <= 0) {
                ParticleMethods.ParticlesAround(this.level(), this.particles, (Entity)this, 10, 0.5);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.DespawnSound, this.getSoundSource(), 1.0f, 3.0f);
                this.discard();
            } else {
                --this.lifespan;
            }
        }
    }
}

