/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.junkyard_lib.entity;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TamableEntity
extends TamableAnimal {
    private final Item tameItem;
    private final Item breedItem;
    public String BEHAVIOR = "WANDER";
    String entityName = this.getEntityName();

    public TamableEntity(EntityType<? extends TamableAnimal> entityType, Level level, Item tameItem, Item breedItem) {
        super(entityType, level);
        this.tameItem = tameItem;
        this.breedItem = breedItem;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                return super.canUse() && !TamableEntity.stay(TamableEntity.this);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                return super.canUse() && TamableEntity.follow(TamableEntity.this);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                return super.canUse() && TamableEntity.wander(TamableEntity.this);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{this.tameItem}), false){

            public boolean canUse() {
                return super.canUse() && !TamableEntity.isTame(TamableEntity.this);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{this.breedItem}), false){

            public boolean canUse() {
                return super.canUse() && !TamableEntity.stay(TamableEntity.this);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                return super.canUse() && !TamableEntity.stay(TamableEntity.this);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && TamableEntity.wander(TamableEntity.this);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static boolean follow(TamableEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isFollowing();
    }

    public static boolean wander(TamableEntity entity) {
        if (entity == null) {
            return false;
        }
        return entity.isWandering();
    }

    public static boolean stay(TamableEntity entity) {
        return !TamableEntity.follow(entity) && !TamableEntity.wander(entity);
    }

    public static boolean isTame(TamableEntity entity) {
        return entity.isTame();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.AXOLOTL_IDLE_AIR;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return SoundEvents.AXOLOTL_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.AXOLOTL_DEATH;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(this.breedItem);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this;
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.is(this.tameItem)) {
            this.usePlayerItem(pPlayer, pHand, itemstack);
            if (!this.isTame()) {
                if (this.random.nextInt(5) == 0) {
                    this.tame(pPlayer);
                    this.BEHAVIOR = "FOLLOW";
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                this.setPersistenceRequired();
                return InteractionResult.SUCCESS;
            }
        } else {
            InteractionResult retval = super.mobInteract(pPlayer, pHand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
            if (this.isOwnedBy((LivingEntity)pPlayer)) {
                this.cycleBehavior(pPlayer);
                return InteractionResult.SUCCESS;
            }
            return retval;
        }
        return InteractionResult.PASS;
    }

    private void setBehaviorInPersistentData(String behavior) {
        CompoundTag tag = this.getPersistentData();
        tag.putString("Behavior", behavior);
    }

    public boolean isFollowing() {
        return this.BEHAVIOR.equals("FOLLOW");
    }

    public boolean isWandering() {
        return this.BEHAVIOR.equals("WANDER");
    }

    private void cycleBehavior(Player pPlayer) {
        switch (this.BEHAVIOR) {
            case "FOLLOW": {
                this.BEHAVIOR = "WANDER";
                pPlayer.displayClientMessage((Component)Component.literal((String)(this.entityName + " will wander")), true);
                break;
            }
            case "STAY": {
                this.BEHAVIOR = "FOLLOW";
                pPlayer.displayClientMessage((Component)Component.literal((String)(this.entityName + " will follow")), true);
                break;
            }
            case "WANDER": {
                this.BEHAVIOR = "STAY";
                pPlayer.displayClientMessage((Component)Component.literal((String)(this.entityName + " will stay")), true);
            }
        }
        this.setBehaviorInPersistentData(this.BEHAVIOR);
    }

    public String getEntityName() {
        if (this.hasCustomName()) {
            return this.getCustomName().getString();
        }
        return this.getType().getDescription().getString();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Behavior", this.BEHAVIOR);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Behavior")) {
            this.BEHAVIOR = compound.getString("Behavior");
        }
    }
}

