/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.junkyard_lib.visual.particle;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ParticleMethods {
    public static void ParticlesBurst(Level level, ParticleOptions particleType, double x, double y, double z, int count, double speed) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particleType, x, y, z, count, 0.0, 0.0, 0.0, speed);
        }
    }

    public static void ParticlesAround(Level level, ParticleOptions particleType, Entity entity, int count, double spread) {
        Random random = new Random();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < count; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * spread;
                double offsetY = (random.nextDouble() - 0.5) * spread;
                double offsetZ = (random.nextDouble() - 0.5) * spread;
                serverLevel.addParticle(particleType, entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void ParticleTrailEntityToEntity(Level level, ParticleOptions particleType, Entity source, Entity destination, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double deltaX = destination.getX() - source.getX();
            double deltaY = destination.getY() - source.getY();
            double deltaZ = destination.getZ() - source.getZ();
            for (int i = 0; i <= count; ++i) {
                double progress = (double)i / (double)count;
                double particleX = destination.getX() + deltaX * progress;
                double particleY = destination.getY() + deltaY * progress + 0.5;
                double particleZ = destination.getZ() + deltaZ * progress;
                serverLevel.sendParticles(particleType, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void ParticleTrailBlockToEntity(Level level, ParticleOptions particleType, BlockPos block, Entity entity, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double deltaX = entity.getX() - (double)block.getX();
            double deltaY = entity.getY() - (double)block.getY();
            double deltaZ = entity.getZ() - (double)block.getZ();
            for (int i = 0; i <= count; ++i) {
                double progress = (double)i / (double)count;
                double particleX = entity.getX() + deltaX * progress;
                double particleY = entity.getY() + deltaY * progress + 0.5;
                double particleZ = entity.getZ() + deltaZ * progress;
                serverLevel.sendParticles(particleType, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void ParticleTrailBlockToBlock(Level level, ParticleOptions particleType, BlockPos source, BlockPos destination, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double deltaX = destination.getX() - source.getX();
            double deltaY = destination.getY() - source.getY();
            double deltaZ = destination.getZ() - source.getZ();
            for (int i = 0; i <= count; ++i) {
                double progress = (double)i / (double)count;
                double particleX = (double)destination.getX() + deltaX * progress;
                double particleY = (double)destination.getY() + deltaY * progress + 0.5;
                double particleZ = (double)destination.getZ() + deltaZ * progress;
                serverLevel.sendParticles(particleType, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

