/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.dracolotl.util.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.trashelemental.dracolotl.dracolotl;
import net.trashelemental.dracolotl.entity.ModEntities;
import net.trashelemental.dracolotl.entity.custom.DracolotlEntity;

@EventBusSubscriber
public class SummonDracolotlEvent {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(BlockTags.create((ResourceLocation)dracolotl.prefix("dragon_eggs"))) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.offset(-2, -2, 0)) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.offset(2, -2, 0)) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.offset(0, -2, -2)) && SummonDracolotlEvent.isEndCrystalNearby(level, pos.offset(0, -2, 2))) {
            event.setCanceled(true);
            SummonDracolotlEvent.setCrystalBeams(level, pos);
            level.playSound(null, pos, SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.removeBlock(pos, false);
            dracolotl.queueServerWork(40, () -> {
                SummonDracolotlEvent.removeEndCrystals(level, pos.offset(-2, -2, 0));
                level.playSound(null, pos.offset(-2, -2, 0), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                dracolotl.queueServerWork(20, () -> {
                    SummonDracolotlEvent.removeEndCrystals(level, pos.offset(2, -2, 0));
                    level.playSound(null, pos.offset(2, -2, 0), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    dracolotl.queueServerWork(20, () -> {
                        SummonDracolotlEvent.removeEndCrystals(level, pos.offset(0, -2, -2));
                        level.playSound(null, pos.offset(0, -2, -2), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        dracolotl.queueServerWork(20, () -> {
                            SummonDracolotlEvent.removeEndCrystals(level, pos.offset(0, -2, 2));
                            level.playSound(null, pos, SoundEvents.ENDER_DRAGON_AMBIENT, SoundSource.BLOCKS, 1.0f, 2.0f);
                            SummonDracolotlEvent.spawnTamedDracolotl(level, pos, player);
                        });
                    });
                });
            });
        }
    }

    private static boolean isEndCrystalNearby(Level level, BlockPos pos) {
        return !level.getEntitiesOfClass(EndCrystal.class, new AABB(pos)).isEmpty();
    }

    private static void removeEndCrystals(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            List crystals = level.getEntitiesOfClass(EndCrystal.class, new AABB(pos));
            for (EndCrystal crystal : crystals) {
                crystal.discard();
                SummonDracolotlEvent.sendParticlePacket(level, (ParticleOptions)ParticleTypes.EXPLOSION, crystal.getX(), crystal.getY(), crystal.getZ(), 5);
            }
        }
    }

    private static void spawnTamedDracolotl(Level level, BlockPos pos, Player player) {
        DracolotlEntity dracolotl2;
        if (!level.isClientSide && (dracolotl2 = (DracolotlEntity)((EntityType)ModEntities.DRACOLOTL.get()).create(level)) != null) {
            dracolotl2.moveTo((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            dracolotl2.setTame(true, false);
            dracolotl2.setOwnerUUID(player.getUUID());
            dracolotl2.BEHAVIOR = "FOLLOW";
            level.addFreshEntity((Entity)dracolotl2);
            SummonDracolotlEvent.sendParticlePacket(level, (ParticleOptions)ParticleTypes.DRAGON_BREATH, dracolotl2.getX(), dracolotl2.getY(), dracolotl2.getZ(), 20);
        }
    }

    private static void sendParticlePacket(Level level, ParticleOptions particleType, double x, double y, double z, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particleType, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static void setCrystalBeams(Level level, BlockPos eggPos) {
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.offset(-2, -2, 0), eggPos);
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.offset(2, -2, 0), eggPos);
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.offset(0, -2, -2), eggPos);
        SummonDracolotlEvent.setCrystalBeamTarget(level, eggPos.offset(0, -2, 2), eggPos);
    }

    private static void setCrystalBeamTarget(Level level, BlockPos crystalPos, BlockPos eggPos) {
        List crystals = level.getEntitiesOfClass(EndCrystal.class, new AABB(crystalPos).inflate(1.0));
        for (EndCrystal crystal : crystals) {
            crystal.setBeamTarget(eggPos);
        }
    }
}

