/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.voidarkana.fintastic.common.block.YAFMBlocks;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.YAFMEntityPlacements;
import net.voidarkana.fintastic.common.event.YAFMEvents;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.common.loot.YAFMLootModifiers;
import net.voidarkana.fintastic.common.sound.YAFMSounds;
import net.voidarkana.fintastic.common.worldgen.YAFMConfiguredFeatures;
import net.voidarkana.fintastic.util.ClientProxy;
import net.voidarkana.fintastic.util.CommonProxy;
import net.voidarkana.fintastic.util.YAFMCreativeTab;
import net.voidarkana.fintastic.util.network.MultipartEntityMessage;
import org.slf4j.Logger;

@Mod(value="fintastic")
public class Fintastic {
    public static final SimpleChannel NETWORK_WRAPPER;
    private static final String PROTOCOL_VERSION;
    private static int packetsRegistered;
    public static final CommonProxy PROXY;
    public static final String MOD_ID = "fintastic";
    public static final List<Runnable> CALLBACKS;
    private static final Logger LOGGER;

    public Fintastic() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        YAFMCreativeTab.register(modEventBus);
        YAFMEntities.register(modEventBus);
        YAFMSounds.register(modEventBus);
        YAFMItems.register(modEventBus);
        YAFMBlocks.register(modEventBus);
        YAFMLootModifiers.register(modEventBus);
        YAFMConfiguredFeatures.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new YAFMEvents());
        PROXY.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            YAFMEntityPlacements.entityPlacement();
            NETWORK_WRAPPER.registerMessage(packetsRegistered++, MultipartEntityMessage.class, MultipartEntityMessage::write, MultipartEntityMessage::read, MultipartEntityMessage::handle);
            ComposterBlock.f_51914_.put((Object)YAFMBlocks.DUCKWEED.get().m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)YAFMBlocks.HORNWORT.get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)YAFMBlocks.ANUBIAS.get()).m_5456_(), 0.4f);
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> PROXY.clientInit());
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    static {
        PROTOCOL_VERSION = Integer.toString(1);
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        NetworkRegistry.ChannelBuilder channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MOD_ID, "main_channel"));
        String version = PROTOCOL_VERSION;
        version.getClass();
        channel = channel.clientAcceptedVersions(version::equals);
        version = PROTOCOL_VERSION;
        version.getClass();
        NETWORK_WRAPPER = channel.serverAcceptedVersions(version::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
        CALLBACKS = new ArrayList<Runnable>();
        LOGGER = LogUtils.getLogger();
    }
}

