/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity;

import net.minecraft.resources.ResourceLocation;
import net.voidarkana.fintastic.common.entity.custom.ArtemiaEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class ArtemiaModel
extends GeoModel<ArtemiaEntity> {
    public ResourceLocation getModelResource(ArtemiaEntity artemiaEntity) {
        return new ResourceLocation("fintastic", "geo/artemia.geo.json");
    }

    public ResourceLocation getTextureResource(ArtemiaEntity artemiaEntity) {
        if (artemiaEntity.isNinni()) {
            return new ResourceLocation("fintastic", "textures/entity/artemia/artemia_ninni.png");
        }
        return switch (artemiaEntity.getVariantSkin()) {
            case 1 -> new ResourceLocation("fintastic", "textures/entity/artemia/artemia_beavertail.png");
            case 2 -> new ResourceLocation("fintastic", "textures/entity/artemia/artemia_thai.png");
            default -> new ResourceLocation("fintastic", "textures/entity/artemia/artemia.png");
        };
    }

    public ResourceLocation getAnimationResource(ArtemiaEntity artemiaEntity) {
        return new ResourceLocation("fintastic", "animations/artemia.animation.json");
    }

    public void setCustomAnimations(ArtemiaEntity animatable, long instanceId, AnimationState<ArtemiaEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        CoreGeoBone swimControl = this.getAnimationProcessor().getBone("swim_control");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head_rot");
        CoreGeoBone tailRot = this.getAnimationProcessor().getBone("tail_rot");
        CoreGeoBone tailTipRot = this.getAnimationProcessor().getBone("tail_tip_rot");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        swimControl.setRotX(entityData.headPitch() * ((float)Math.PI / 180) * 1.8f);
        head.setRotX(entityData.headPitch() * ((float)Math.PI / 180) / 8.0f);
        tailRot.setRotX(-(entityData.headPitch() * ((float)Math.PI / 180) / 4.0f));
        tailTipRot.setRotX(-(entityData.headPitch() * ((float)Math.PI / 180) / 4.0f));
    }
}

