/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity.gourami;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.fintastic.client.animation.GouramiAnims;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.common.entity.custom.Gourami;

public class GouramiMedModel<T extends Gourami>
extends FintasticModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart mouth;
    private final ModelPart dorsalfin;
    private final ModelPart analfin;
    private final ModelPart pelvicfinleft;
    private final ModelPart pelvicfinright;
    private final ModelPart leftfin;
    private final ModelPart rightfin;
    private final ModelPart tailfin;

    public GouramiMedModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.mouth = this.body.m_171324_("mouth");
        this.dorsalfin = this.body.m_171324_("dorsalfin");
        this.analfin = this.body.m_171324_("analfin");
        this.pelvicfinleft = this.body.m_171324_("pelvicfinleft");
        this.pelvicfinright = this.body.m_171324_("pelvicfinright");
        this.leftfin = this.body.m_171324_("leftfin");
        this.rightfin = this.body.m_171324_("rightfin");
        this.tailfin = this.body.m_171324_("tailfin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)-5.5f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.5f, -1.5f, 2.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = body.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-1.5f));
        PartDefinition dorsalfin = body.m_171599_("dorsalfin", CubeListBuilder.m_171558_().m_171514_(15, 14).m_171488_(0.0f, -3.0f, -3.5f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)4.0f));
        PartDefinition analfin = body.m_171599_("analfin", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(0.0f, -2.0f, -3.5f, 0.0f, 5.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)5.0f));
        PartDefinition pelvicfinleft = body.m_171599_("pelvicfinleft", CubeListBuilder.m_171558_().m_171514_(13, 24).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)2.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.7418f));
        PartDefinition pelvicfinright = body.m_171599_("pelvicfinright", CubeListBuilder.m_171558_().m_171514_(13, 24).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)2.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7418f));
        PartDefinition leftfin = body.m_171599_("leftfin", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)2.5f, (float)0.0f, (float)0.8727f, (float)0.0f));
        PartDefinition rightfin = body.m_171599_("rightfin", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)2.5f, (float)0.0f, (float)-0.8727f, (float)0.0f));
        PartDefinition tailfin = body.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)7.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Gourami pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateIdle(pEntity.idleAnimationState, GouramiAnims.IDLE, pAgeInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount)));
        this.animateIdle(pEntity.flopAnimationState, GouramiAnims.FLOP, pAgeInTicks, 1.0f, (float)pEntity.getTicksOutsideWater() / 3.0f);
        if (pEntity.m_20072_()) {
            this.swim_rot.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
            this.swim_rot.f_104205_ = pNetHeadYaw * ((float)Math.PI / 360);
            this.m_267799_(GouramiAnims.SWIM, pLimbSwing, pLimbSwingAmount, 2.0f, 3.0f);
        } else {
            this.swim_rot.m_233569_();
            this.m_288214_(GouramiAnims.MED_FLOP_OFFSET);
        }
        this.m_233381_(pEntity.investigatingAnimationState, GouramiAnims.INVESTIGATE_LONG, pAgeInTicks);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, 1.6, 0.0);
        } else {
            poseStack.m_85837_(0.0, 0.2, 0.0);
        }
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

