/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.voidarkana.fintastic.client.FintasticLayers;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.client.models.entity.moonies.MoonyMidModel;
import net.voidarkana.fintastic.client.models.entity.moonies.MoonySmallModel;
import net.voidarkana.fintastic.client.models.entity.moonies.MoonyTallModel;
import net.voidarkana.fintastic.common.entity.custom.Moony;
import org.jetbrains.annotations.Nullable;

public class MoonyRenderer
extends MobRenderer<Moony, FintasticModel<Moony>> {
    private final MoonyMidModel<Moony> moonyMidModel;
    private final MoonySmallModel<Moony> moonySmallModel;
    private final MoonyTallModel<Moony> moonyTallModel;

    public MoonyRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new MoonyMidModel(pContext.m_174023_(FintasticLayers.MOONYMID_LAYER)), 0.5f);
        this.moonyMidModel = new MoonyMidModel(pContext.m_174023_(FintasticLayers.MOONYMID_LAYER));
        this.moonySmallModel = new MoonySmallModel(pContext.m_174023_(FintasticLayers.MOONYSMALL_LAYER));
        this.moonyTallModel = new MoonyTallModel(pContext.m_174023_(FintasticLayers.MOONYTALL_LAYER));
    }

    public void render(Moony entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        switch (entity.getVariantModel()) {
            case 1: {
                this.f_115290_ = this.moonySmallModel;
                break;
            }
            case 2: {
                this.f_115290_ = this.moonyTallModel;
                break;
            }
            default: {
                this.f_115290_ = this.moonyMidModel;
            }
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(Moony pEntity) {
        return new ResourceLocation("fintastic", "textures/entity/moony/" + pEntity.getVariantName() + ".png");
    }

    @Nullable
    protected RenderType getRenderType(Moony pEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        return RenderType.m_110452_((ResourceLocation)new ResourceLocation("fintastic", "textures/entity/moony/" + pEntity.getVariantName() + ".png"));
    }

    protected void setupRotations(Moony pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(pEntityLiving.currentRoll * 360.0f / 4.0f));
    }
}

