/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.FishJumpGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.VariantSchoolingFish;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FreshwaterSharkEntity
extends VariantSchoolingFish
implements GeoEntity {
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.genericfish.swim");
    protected static final RawAnimation FLOP = RawAnimation.begin().thenLoop("animation.genericfish.flop");
    protected static final RawAnimation HEAD_SWIM = RawAnimation.begin().thenLoop("animation.genericfish.headswim");
    protected static final RawAnimation HEAD_FLOP = RawAnimation.begin().thenLoop("animation.genericfish.headflop");
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FreshwaterSharkEntity(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_6210_();
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return switch (this.getVariantModel()) {
            case 1, 4 -> super.m_6972_(pPose).m_20390_(1.5f, 1.5f);
            case 2 -> super.m_6972_(pPose).m_20390_(1.7f, 1.7f);
            case 3, 5 -> super.m_6972_(pPose).m_20390_(1.0f, 1.0f);
            default -> super.m_6972_(pPose);
        };
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FishJumpGoal(this, 15));
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("VariantModel", this.getVariantModel());
        compoundnbt.m_128405_("VariantSkin", this.getVariantSkin());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("VariantModel", 3)) {
            this.setVariantModel(pDataTag.m_128451_("VariantModel"));
            this.setVariantSkin(pDataTag.m_128451_("VariantSkin"));
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        } else {
            int skin;
            int model;
            if (pSpawnData instanceof FishGroupData) {
                FishGroupData fish$fishgroupdata = (FishGroupData)pSpawnData;
                model = fish$fishgroupdata.variantModel;
                skin = fish$fishgroupdata.variantSkin;
                this.startFollowing(((FishGroupData)pSpawnData).leader);
            } else {
                model = pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207610_) ? (this.f_19796_.m_188499_() ? 0 : 2) : (this.f_19796_.m_188499_() ? 1 : 3);
                skin = model == 1 ? this.f_19796_.m_188503_(3) : 0;
                pSpawnData = new FishGroupData(this, model, skin);
            }
            this.setVariantModel(model);
            this.setVariantSkin(skin);
        }
        return pSpawnData;
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        FreshwaterSharkEntity baby = (FreshwaterSharkEntity)((EntityType)YAFMEntities.FRESHWATER_SHARK.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.setVariantModel(this.getVariantModel());
            if (this.getVariantModel() == 1) {
                FreshwaterSharkEntity otherParent = (FreshwaterSharkEntity)pOtherParent;
                int lowerQuality = Math.min(this.getFeedQuality(), otherParent.getFeedQuality());
                switch (lowerQuality) {
                    case 1: {
                        baby.setVariantSkin(this.f_19796_.m_188499_() ? this.f_19796_.m_188503_(3) : (this.f_19796_.m_188499_() ? this.getVariantSkin() : otherParent.getVariantSkin()));
                        break;
                    }
                    case 2: 
                    case 3: {
                        baby.setVariantSkin(this.f_19796_.m_188499_() ? this.getVariantSkin() : otherParent.getVariantSkin());
                        break;
                    }
                    default: {
                        baby.setVariantSkin(this.f_19796_.m_188503_(3));
                    }
                }
            }
            baby.m_27497_(true);
        }
        return baby;
    }

    @Override
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.FRESHWATER_SHARK_BUCKET.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    protected <E extends FreshwaterSharkEntity> PlayState Controller(AnimationState<E> event) {
        if (this.m_20069_()) {
            event.setAndContinue(this.getVariantModel() == 0 ? SWIM : HEAD_SWIM);
            event.getController().setAnimationSpeed(1.5);
        } else {
            event.setAndContinue(this.getVariantModel() == 0 ? FLOP : HEAD_FLOP);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        FreshwaterSharkEntity mate = (FreshwaterSharkEntity)pOtherAnimal;
        return super.canMate(pOtherAnimal) && this.getVariantModel() == mate.getVariantModel();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class FishGroupData
    extends VariantSchoolingFish.SchoolSpawnGroupData {
        final int variantModel;
        final int variantSkin;

        FishGroupData(FreshwaterSharkEntity pLeader, int pVariantModel, int pVariantSkin) {
            super(pLeader);
            this.variantModel = pVariantModel;
            this.variantSkin = pVariantSkin;
        }
    }
}

