/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.Tags;
import net.voidarkana.fintastic.common.entity.YAFMEntities;
import net.voidarkana.fintastic.common.entity.custom.ai.FishBreedGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.boids.BoidGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.boids.LimitSpeedAndLookInVelocityDirectionGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.boids.OrganizeBoidsVariantGoal;
import net.voidarkana.fintastic.common.entity.custom.ai.boids.StayInWaterGoal;
import net.voidarkana.fintastic.common.entity.custom.base.BreedableWaterAnimal;
import net.voidarkana.fintastic.common.entity.custom.base.BucketableFishEntity;
import net.voidarkana.fintastic.common.entity.custom.base.VariantBoidingFish;
import net.voidarkana.fintastic.common.item.YAFMItems;
import net.voidarkana.fintastic.util.YAFMTags;
import org.jetbrains.annotations.Nullable;

public class Moony
extends VariantBoidingFish {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flopAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(YAFMTags.Items.FISH_FEED);

    public Moony(EntityType<? extends BucketableFishEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 2.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(1, (Goal)new FishBreedGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_() && !player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)YAFMItems.FISHING_HAT.get());
            }
            return false;
        }));
        this.f_21345_.m_25352_(1, (Goal)new OrganizeBoidsVariantGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BoidGoal(this, 0.2f, 0.75f, 0.4f, 0.05f));
        this.f_21345_.m_25352_(2, (Goal)new StayInWaterGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LimitSpeedAndLookInVelocityDirectionGoal(this, 0.65f));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariantModel(compound.m_128451_("VariantModel"));
        this.setVariantSkin(compound.m_128451_("VariantSkin"));
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        compoundnbt.m_128405_("VariantModel", this.getVariantModel());
        compoundnbt.m_128405_("VariantSkin", this.getVariantSkin());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
        this.flopAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        }
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("VariantModel", 3)) {
            this.setVariantModel(pDataTag.m_128451_("VariantModel"));
            this.setVariantSkin(pDataTag.m_128451_("VariantSkin"));
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setCanGrowUp(pDataTag.m_128471_("CanGrow"));
        } else {
            int skin = this.f_19796_.m_188503_(2);
            if (pReason == MobSpawnType.SPAWN_EGG || pReason == MobSpawnType.BUCKET && pDataTag == null) {
                this.setVariantModel(this.f_19796_.m_188503_(3));
            } else {
                int model;
                if (pSpawnData instanceof MinnowGroupData) {
                    MinnowGroupData groupData = (MinnowGroupData)pSpawnData;
                    model = groupData.getVariantModel();
                    skin = groupData.getVariantSkin();
                    this.startFollowing(groupData.leader);
                } else {
                    model = pLevel.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_SWAMP) ? this.f_19796_.m_188503_(3) : (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207604_) ? 0 : (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207603_) ? this.f_19796_.m_216339_(1, 3) : this.f_19796_.m_188503_(3)));
                    pSpawnData = new MinnowGroupData(this, model, skin);
                }
                this.setVariantModel(model);
            }
            this.setVariantSkin(skin);
        }
        return pSpawnData;
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Moony baby = (Moony)((EntityType)YAFMEntities.MOONY.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.m_27497_(true);
            baby.setVariantModel(this.getVariantModel());
            baby.setVariantSkin(this.getVariantSkin());
        }
        return baby;
    }

    @Override
    public boolean canMate(BreedableWaterAnimal pOtherAnimal) {
        Moony mate = (Moony)pOtherAnimal;
        return super.canMate(pOtherAnimal) && mate.getVariantModel() == this.getVariantModel() && mate.getVariantSkin() == this.getVariantSkin();
    }

    @Override
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)YAFMItems.MOONY_BUCKET.get());
    }

    public String getVariantName() {
        Object variant = switch (this.getVariantModel()) {
            case 1 -> "moonysmall";
            case 2 -> "moonytall";
            default -> "moony";
        };
        variant = this.getVariantSkin() == 0 ? (String)variant + "_0" : (String)variant + "_1";
        return variant;
    }

    public static String getVariantName(int variantModel, int variantSkin) {
        Object variant = switch (variantModel) {
            case 1 -> "moonysmall";
            case 2 -> "moonytall";
            default -> "moony";
        };
        variant = variantSkin == 0 ? (String)variant + "_0" : (String)variant + "_1";
        return variant;
    }

    @Override
    public boolean canBabiesSchoolWithAdults() {
        return true;
    }

    static class MinnowGroupData
    extends VariantBoidingFish.SchoolSpawnGroupData {
        final int variantModel;
        final int variantSkin;

        MinnowGroupData(Moony pLeader, int pVariantModel, int pVariantSkin) {
            super(pLeader);
            this.variantModel = pVariantModel;
            this.variantSkin = pVariantSkin;
        }

        public int getVariantModel() {
            return this.variantModel;
        }

        public int getVariantSkin() {
            return this.variantSkin;
        }
    }
}

