/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.common.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.voidarkana.fintastic.common.worldgen.YAFMConfiguredFeatures;

public class YAFMPlacedFeatures {
    public static final ResourceKey<PlacedFeature> HORNWORT_PLACED_KEY = YAFMPlacedFeatures.registerKey("hornwort_placed");
    public static final ResourceKey<PlacedFeature> DUCKWEED_PLACED_KEY = YAFMPlacedFeatures.registerKey("duckweed_placed");
    public static final ResourceKey<PlacedFeature> LIVE_ROCK_PLACED_KEY = YAFMPlacedFeatures.registerKey("live_rock_boulder_placed");
    public static final ResourceKey<PlacedFeature> STROMATOLITE_PLACED_KEY = YAFMPlacedFeatures.registerKey("stromatolite_placed");
    public static final ResourceKey<PlacedFeature> FOSSIL_STROMATOLITE_PLACED_KEY = YAFMPlacedFeatures.registerKey("fossil_stromatolite_placed");
    public static final ResourceKey<PlacedFeature> ANUBIAS_PLACED_KEY = YAFMPlacedFeatures.registerKey("anubias_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        YAFMPlacedFeatures.register(context, HORNWORT_PLACED_KEY, configuredFeatures.m_255043_(YAFMConfiguredFeatures.HORNWORT_KEY), YAFMPlacedFeatures.aquaticPlantPlacement(48));
        YAFMPlacedFeatures.register(context, DUCKWEED_PLACED_KEY, configuredFeatures.m_255043_(YAFMConfiguredFeatures.DUCKWEED_KEY), YAFMPlacedFeatures.worldSurfaceSquaredWithCount(12));
        YAFMPlacedFeatures.register(context, LIVE_ROCK_PLACED_KEY, configuredFeatures.m_255043_(YAFMConfiguredFeatures.LIVE_ROCK_BOULDER), YAFMPlacedFeatures.underwaterBoulderPlacement(4));
        YAFMPlacedFeatures.register(context, STROMATOLITE_PLACED_KEY, configuredFeatures.m_255043_(YAFMConfiguredFeatures.STROMATOLITE_RANDOM_PATCH), YAFMPlacedFeatures.stromatolitePlacement());
        YAFMPlacedFeatures.register(context, FOSSIL_STROMATOLITE_PLACED_KEY, configuredFeatures.m_255043_(YAFMConfiguredFeatures.FOSSIL_STROMATOLITE_PATCH), new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)20)), BiomeFilter.m_191561_()});
        YAFMPlacedFeatures.register(context, ANUBIAS_PLACED_KEY, configuredFeatures.m_255043_(YAFMConfiguredFeatures.ANUBIAS_KEY), YAFMPlacedFeatures.aquaticPlantPlacement(1));
    }

    private static List<PlacementModifier> aquaticPlantPlacement(int pCount) {
        return List.of(InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, CountPlacement.m_191628_((int)pCount), BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> stromatolitePlacement() {
        return List.of(InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, RarityFilter.m_191900_((int)4), BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> worldSurfaceSquaredWithCount(int pCount) {
        return List.of(CountPlacement.m_191628_((int)pCount), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> underwaterBoulderPlacement(int pCount) {
        return List.of(RarityFilter.m_191900_((int)pCount), InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BiomeFilter.m_191561_());
    }

    public static void register(BootstapContext<PlacedFeature> pContext, ResourceKey<PlacedFeature> pKey, Holder<ConfiguredFeature<?, ?>> pConfiguredFeatures, PlacementModifier ... pPlacements) {
        YAFMPlacedFeatures.register(pContext, pKey, pConfiguredFeatures, List.of(pPlacements));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("fintastic", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

