/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.mixin;

import com.conquestrefabricated.core.block.properties.ModBlockProperties;
import com.conquestreforged.content.blocks.BlockSettingsAccessor;
import com.conquestreforged.content.blocks.CustomOffsetType;
import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.Properties.class})
public abstract class BlockSettingsOffsetMixin
implements BlockSettingsAccessor {
    @Unique
    private CustomOffsetType customOffsetType = null;

    @Inject(method={"offset"}, at={@At(value="HEAD")}, cancellable=true)
    private void customOffset(BlockBehaviour.OffsetType offsetType, CallbackInfoReturnable<BlockBehaviour.Properties> cir) {
        BlockBehaviour.Properties settings = (BlockBehaviour.Properties)this;
        if (this.customOffsetType != null) {
            if (offsetType == BlockBehaviour.OffsetType.XYZ) {
                settings.f_271289_ = Optional.of((state, world, pos) -> {
                    Block block = state.m_60734_();
                    long l = Mth.m_14130_((int)pos.m_123341_(), (int)0, (int)pos.m_123343_());
                    double d = ((double)((float)(l >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.m_142627_();
                    float f = block.m_142740_();
                    double e = Mth.m_14008_((double)(((double)((float)(l & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-f), (double)f);
                    double g = Mth.m_14008_((double)(((double)((float)(l >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-f), (double)f);
                    Vec3 randomOffset = new Vec3(e, d, g);
                    return randomOffset;
                });
                cir.setReturnValue((Object)settings);
            } else if (offsetType == BlockBehaviour.OffsetType.XZ) {
                settings.f_271289_ = Optional.of((state, world, pos) -> {
                    Block block = state.m_60734_();
                    long l = Mth.m_14130_((int)pos.m_123341_(), (int)0, (int)pos.m_123343_());
                    float f = block.m_142740_();
                    double d = Mth.m_14008_((double)(((double)((float)(l & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-f), (double)f);
                    double e = Mth.m_14008_((double)(((double)((float)(l >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-f), (double)f);
                    return new Vec3(d, 0.0, e);
                });
                cir.setReturnValue((Object)settings);
            } else if (this.customOffsetType == CustomOffsetType.LAYER_Y) {
                settings.f_271289_ = Optional.of((state, world, pos) -> {
                    if (((Boolean)state.m_61143_((Property)ModBlockProperties.OFFSET_TOGGLE)).booleanValue()) {
                        double layerY = 0.0;
                        BlockPos belowPos = pos.m_7495_();
                        BlockState belowState = world.m_8055_(belowPos);
                        Block belowBlock = belowState.m_60734_();
                        layerY = this.computeTranslationAmount(belowState).floatValue();
                        return new Vec3(0.0, layerY, 0.0);
                    }
                    return new Vec3(0.0, 0.0, 0.0);
                });
                cir.setReturnValue((Object)settings);
            } else if (this.customOffsetType == CustomOffsetType.LAYER_XYZ) {
                settings.f_271289_ = Optional.of((state, world, pos) -> {
                    if (((Boolean)state.m_61143_((Property)ModBlockProperties.OFFSET_TOGGLE)).booleanValue()) {
                        Direction direction;
                        BlockState offsetBlock;
                        float translationAmountX = 0.0f;
                        float translationAmountZ = 0.0f;
                        float translationAmountY = 0.0f;
                        BlockState blockStateDown = world.m_8055_(pos.m_7495_());
                        Block blockDown = blockStateDown.m_60734_();
                        if (state.m_61138_((Property)BlockStateProperties.f_61374_) && (offsetBlock = world.m_8055_(pos.m_5484_((direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_(), 1))).m_60734_() instanceof VerticalSlab && direction == offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_)) {
                            switch (direction) {
                                case NORTH: {
                                    translationAmountZ = -this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case EAST: {
                                    translationAmountX = this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case SOUTH: {
                                    translationAmountZ = this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case WEST: {
                                    translationAmountX = -this.computeVerticalSlabTranslation(offsetBlock);
                                }
                            }
                        }
                        translationAmountY = blockDown instanceof SlabBlock && blockStateDown.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM ? -0.5f : this.computeYTranslation(blockStateDown);
                        return new Vec3((double)translationAmountX, (double)translationAmountY, (double)translationAmountZ);
                    }
                    return new Vec3(0.0, 0.0, 0.0);
                });
                cir.setReturnValue((Object)settings);
            } else if (this.customOffsetType == CustomOffsetType.LAYER_XYZ_NSEWUD) {
                settings.f_271289_ = Optional.of((state, world, pos) -> {
                    if (((Boolean)state.m_61143_((Property)ModBlockProperties.OFFSET_TOGGLE)).booleanValue()) {
                        float translationAmountX = 0.0f;
                        float translationAmountZ = 0.0f;
                        float translationAmountY = 0.0f;
                        BlockState blockStateDown = world.m_8055_(pos.m_7495_());
                        Block blockDown = blockStateDown.m_60734_();
                        Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
                        BlockState offsetBlock = world.m_8055_(pos.m_5484_(direction.m_122424_(), 1));
                        if (offsetBlock.m_60734_() instanceof VerticalSlab && direction == offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_)) {
                            switch (direction) {
                                case NORTH: {
                                    translationAmountZ = -this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case EAST: {
                                    translationAmountX = this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case SOUTH: {
                                    translationAmountZ = this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case WEST: {
                                    translationAmountX = -this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                            }
                        }
                        translationAmountY = blockDown instanceof SlabBlock && blockStateDown.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM ? -0.5f : this.computeYTranslation(blockStateDown);
                        return new Vec3((double)translationAmountX, (double)translationAmountY, (double)translationAmountZ);
                    }
                    return new Vec3(0.0, 0.0, 0.0);
                });
                cir.setReturnValue((Object)settings);
            } else if (this.customOffsetType == CustomOffsetType.LAYER_XYZ_LICHEN) {
                settings.f_271289_ = Optional.of((state, world, pos) -> {
                    if (((Boolean)state.m_61143_((Property)ModBlockProperties.OFFSET_TOGGLE)).booleanValue()) {
                        float translationAmountX = 0.0f;
                        float translationAmountZ = 0.0f;
                        float translationAmountY = 0.0f;
                        Direction connectedDir = this.getLichenMossConnectionDirection(state);
                        Direction directionXZ = connectedDir.m_122424_();
                        BlockState offsetBlock = world.m_8055_(pos.m_5484_(connectedDir, 1));
                        if (offsetBlock.m_60734_() instanceof VerticalSlab && offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_) == directionXZ) {
                            switch (connectedDir) {
                                case NORTH: {
                                    translationAmountZ = this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case EAST: {
                                    translationAmountX = -this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case SOUTH: {
                                    translationAmountZ = -this.computeVerticalSlabTranslation(offsetBlock);
                                    break;
                                }
                                case WEST: {
                                    translationAmountX = this.computeVerticalSlabTranslation(offsetBlock);
                                }
                            }
                        }
                        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55153_)).booleanValue()) {
                            BlockState blockStateDown = world.m_8055_(pos.m_7495_());
                            translationAmountY = this.computeYTranslation(blockStateDown);
                        }
                        return new Vec3((double)translationAmountX, (double)translationAmountY, (double)translationAmountZ);
                    }
                    return new Vec3(0.0, 0.0, 0.0);
                });
                cir.setReturnValue((Object)settings);
            }
        }
    }

    @Unique
    private Direction getLichenMossConnectionDirection(BlockState state) {
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55148_)).booleanValue()) {
            return Direction.NORTH;
        }
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55149_)).booleanValue()) {
            return Direction.EAST;
        }
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55150_)).booleanValue()) {
            return Direction.SOUTH;
        }
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55151_)).booleanValue()) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    @Unique
    private float computeVerticalSlabTranslation(BlockState offsetBlock) {
        int layers = (Integer)offsetBlock.m_61143_((Property)VerticalSlab.LAYERS);
        return switch (layers) {
            case 1 -> -0.875f;
            case 2 -> -0.75f;
            case 3 -> -0.5f;
            case 4 -> -0.25f;
            default -> 0.0f;
        };
    }

    @Unique
    private float computeYTranslation(BlockState downState) {
        Block block = downState.m_60734_();
        if (block instanceof SlabBlock && downState.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
            return -0.5f;
        }
        if (block instanceof Layer || block instanceof SnowLayerBlock) {
            int layers = (Integer)downState.m_61143_((Property)BlockStateProperties.f_61417_);
            return switch (layers) {
                case 7 -> -0.125f;
                case 6 -> -0.25f;
                case 5 -> -0.375f;
                case 4 -> -0.5f;
                case 3 -> -0.625f;
                case 2 -> -0.75f;
                case 1 -> -0.875f;
                default -> 0.0f;
            };
        }
        if (block instanceof Slab && downState.m_61143_(Slab.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)Slab.LAYERS);
            return switch (layers) {
                case 7 -> -0.125f;
                case 6 -> -0.25f;
                case 5 -> -0.375f;
                case 4 -> -0.5f;
                case 3 -> -0.625f;
                case 2 -> -0.75f;
                case 1 -> -0.875f;
                default -> 0.0f;
            };
        }
        if (block instanceof SlabLessLayers && downState.m_61143_(SlabLessLayers.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)SlabLessLayers.LAYERS);
            return switch (layers) {
                case 4 -> -0.25f;
                case 3 -> -0.5f;
                case 2 -> -0.75f;
                case 1 -> -0.875f;
                default -> 0.0f;
            };
        }
        if (block instanceof BoardsHorizontal && downState.m_61143_(com.conquestreforged.content.blocks.block.directional.Half.TYPE_UPDOWN) == Half.BOTTOM) {
            return -0.53125f;
        }
        return 0.0f;
    }

    @Unique
    private Float computeTranslationAmount(BlockState downState) {
        Block blockDown = downState.m_60734_();
        if (blockDown instanceof SlabBlock && downState.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
            return Float.valueOf(-0.5f);
        }
        if (blockDown instanceof Layer || blockDown instanceof SnowLayerBlock) {
            int layers = (Integer)downState.m_61143_((Property)BlockStateProperties.f_61417_);
            return Float.valueOf(this.getTranslationForStandardLayers(layers));
        }
        if (blockDown instanceof Slab && downState.m_61143_(Slab.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)Slab.LAYERS);
            return Float.valueOf(this.getTranslationForStandardLayers(layers));
        }
        if (blockDown instanceof SlabLessLayers && downState.m_61143_(SlabLessLayers.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)SlabLessLayers.LAYERS);
            return Float.valueOf(this.getTranslationForSlabLessLayers(layers));
        }
        if (blockDown instanceof BoardsHorizontal && downState.m_61143_(com.conquestreforged.content.blocks.block.directional.Half.TYPE_UPDOWN) == Half.BOTTOM) {
            return Float.valueOf(-0.53125f);
        }
        return Float.valueOf(0.0f);
    }

    @Unique
    private float getTranslationForStandardLayers(int layers) {
        return switch (layers) {
            case 7 -> -0.125f;
            case 6 -> -0.25f;
            case 5 -> -0.375f;
            case 4 -> -0.5f;
            case 3 -> -0.625f;
            case 2 -> -0.75f;
            case 1 -> -0.875f;
            default -> 0.0f;
        };
    }

    @Unique
    private float getTranslationForSlabLessLayers(int layers) {
        return switch (layers) {
            case 4 -> -0.25f;
            case 3 -> -0.5f;
            case 2 -> -0.75f;
            case 1 -> -0.875f;
            default -> 0.0f;
        };
    }

    @Override
    @Unique
    public BlockBehaviour.Properties setCustomOffsetter(CustomOffsetType offsetter) {
        this.customOffsetType = offsetter;
        return (BlockBehaviour.Properties)this;
    }
}

