/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui;

import com.conquestreforged.client.gui.render.Render;
import com.conquestreforged.client.utils.CreativeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class PickerScreen<T>
extends Screen {
    private final ItemStack stack;
    private final T selected;
    private final List<T> options;
    private int index = -1;

    public PickerScreen(String title, ItemStack stack, T selected, List<T> options) {
        super((Component)Component.m_237113_((String)title));
        this.stack = stack;
        this.options = options;
        this.selected = selected;
    }

    public boolean match(T a, T b) {
        return a.equals(b);
    }

    public void m_7856_() {
        super.m_7856_();
        this.index = this.indexOf(this.selected, this.options);
        Render.hideMouse();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        Minecraft.m_91087_().m_91152_(null);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int typedChar, int keyCode, int what) {
        if (typedChar == 263 && --this.index < 0) {
            this.index = this.options.size() - 1;
        }
        if (typedChar == 262 && ++this.index >= this.options.size()) {
            this.index = 0;
        }
        return super.m_7933_(typedChar, keyCode, what);
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        int size;
        this.m_280039_(matrixStack);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int maxWidth = this.options.size() / 2;
        int visited = 0;
        for (int i = size = Math.min(maxWidth, this.getSize()); i >= 0; --i) {
            if (i == 0) {
                this.renderOption(matrixStack, centerX, centerY, i);
                continue;
            }
            this.renderOption(matrixStack, centerX, centerY, i);
            if (++visited >= this.options.size() - 1) continue;
            this.renderOption(matrixStack, centerX, centerY, -i);
        }
        this.drawLabel(matrixStack, centerX, centerY);
    }

    public boolean m_6050_(double mx, double my, double scroll) {
        if (scroll > 0.0 && --this.index < 0) {
            this.index = this.options.size() - 1;
        }
        if (scroll < 0.0 && ++this.index >= this.options.size()) {
            this.index = 0;
        }
        return false;
    }

    public void m_7861_() {
        Render.showMouse();
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null || !this.f_96541_.f_91074_.m_7500_()) {
            return;
        }
        T option = this.options.get(this.index);
        CreativeUtils.replaceItemStack(this.stack, this.createItemStack(this.stack, option));
    }

    private void renderOption(GuiGraphics matrixStack, int cx, int cy, int di) {
        int height;
        int index = this.index + di;
        if (index < 0) {
            index += this.options.size();
        }
        if (index >= this.options.size()) {
            index -= this.options.size();
        }
        if (index < 0 || index >= this.options.size()) {
            return;
        }
        float scale = 2.0f - (float)Math.abs(di) / 4.0f;
        float count = this.getSize() * 2 + 1;
        int size = Math.round((float)this.f_96543_ / count * scale);
        int left = cx + 1 + di * (size + 1) - size / 2;
        int top = cy - size / 2;
        T option = this.options.get(index);
        float w = 1.0f;
        float h = 1.0f;
        int width = this.getWidth(option);
        if (width != (height = this.getHeight(option))) {
            float scale1 = 1.0f / (float)Math.max(width, height);
            w = (float)width * scale1;
            h = (float)height * scale1;
        }
        int tw = Math.round((float)size * w);
        int th = Math.round((float)size * h);
        int tl = left + (size - tw) / 2;
        int tt = top + (size - th) / 2;
        float alpha = Math.min(1.0f, 0.4f + Math.max(0.0f, 1.0f - (float)Math.abs(di) / 2.0f));
        RenderSystem.setShaderColor((float)alpha, (float)alpha, (float)alpha, (float)1.0f);
        matrixStack.m_280168_().m_85836_();
        matrixStack.m_280168_().m_252880_(0.0f, 0.0f, scale * 50.0f);
        this.render(option, matrixStack, tl, tt, tw, th, scale);
        matrixStack.m_280168_().m_85849_();
    }

    private void drawLabel(GuiGraphics matrixStack, int centerX, int centerY) {
        if (this.index < 0 || this.index >= this.options.size()) {
            return;
        }
        int height = this.f_96543_ / (this.getSize() * 2 + 1) + 10;
        int barWidth = 150;
        int barLeft = this.f_96543_ / 2 - barWidth / 2;
        int barTop = centerY + height + this.getYOffset();
        int barRight = barLeft + barWidth;
        int barBottom = barTop + 3;
        float position = (float)this.index / (float)(this.options.size() - 1);
        int posLeft = barLeft + Math.round(position * (float)barWidth) - 1;
        int posRight = posLeft + 2;
        matrixStack.m_280024_(barLeft, barTop, barRight, barBottom, 0x44000000, 0x44000000);
        matrixStack.m_280024_(posLeft, barTop, posRight, barBottom, 0x66FFFFFF, 0x66FFFFFF);
        T option = this.options.get(this.index);
        String text = this.getDisplayName(option);
        int width = this.f_96547_.m_92895_(text);
        float top = barTop + 15;
        float left = (float)centerX - (float)width / 2.0f;
        matrixStack.m_280488_(this.f_96547_, text, (int)left, (int)top, 0xFFFFFF);
    }

    private int indexOf(T value, List<T> options) {
        for (int i = 0; i < options.size(); ++i) {
            if (!this.match(value, options.get(i))) continue;
            return i;
        }
        return 0;
    }

    public int getSize() {
        return 5;
    }

    public int getYOffset() {
        return 0;
    }

    public abstract int getWidth(T var1);

    public abstract int getHeight(T var1);

    public abstract String getDisplayName(T var1);

    public abstract void render(T var1, GuiGraphics var2, int var3, int var4, int var5, int var6, float var7);

    public abstract ItemStack createItemStack(ItemStack var1, T var2);
}

