/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette;

import com.conquestreforged.client.BindManager;
import com.conquestreforged.client.gui.palette.Palette;
import com.conquestreforged.client.gui.palette.PaletteContainer;
import com.conquestreforged.client.gui.palette.PaletteScreen;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PaletteGuiEvents {
    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        Screen screen;
        if ((event.getAction() == 1 || event.getAction() == 2) && (screen = Minecraft.m_91087_().f_91080_) instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || !player.m_150110_().f_35937_) {
                return;
            }
            if (screen2 instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen2;
                int tabIndex = BuiltInRegistries.f_279662_.m_7447_((Object)CreativeModeInventoryScreen.f_98507_);
                if (tabIndex == BuiltInRegistries.f_279662_.m_7447_((Object)CreativeModeTabs.m_258007_())) {
                    return;
                }
            }
            if (screen2 instanceof PaletteScreen) {
                if (PaletteScreen.closesGui(event.getKey())) {
                    screen2.m_7379_();
                    return;
                }
                if (event.getKey() == Minecraft.m_91087_().f_91066_.f_92092_.m_90861_().m_84873_()) {
                    event.setCanceled(true);
                    Minecraft.m_91087_().m_91152_((Screen)new CreativeModeInventoryScreen((Player)player, FeatureFlagSet.m_246902_(), true));
                    return;
                }
            }
            if (event.getKey() != BindManager.getPaletteBind().m_90861_().m_84873_()) {
                return;
            }
            Slot slot = screen2.getSlotUnderMouse();
            if (slot == null || !slot.m_6657_()) {
                return;
            }
            ItemStack stack = slot.m_7993_();
            Optional<Container> palette = Palette.getPalette(stack);
            if (!palette.isPresent()) {
                return;
            }
            PaletteContainer container = new PaletteContainer((Container)player.m_150109_(), palette.get());
            PaletteScreen paletteScreen = new PaletteScreen((Screen)screen2, (Player)player, player.m_150109_(), container);
            Minecraft.m_91087_().m_91152_((Screen)paletteScreen);
        }
    }

    @SubscribeEvent
    public static void onRender(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id() == VanillaGuiOverlay.HOTBAR.id() && Minecraft.m_91087_().f_91080_ instanceof PaletteScreen) {
            event.setCanceled(true);
        }
    }
}

