/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette;

import com.conquestreforged.client.BindManager;
import com.conquestreforged.client.gui.CustomCreativeScreen;
import com.conquestreforged.client.gui.palette.PaletteContainer;
import com.conquestreforged.client.gui.palette.component.PaletteSettings;
import com.conquestreforged.client.gui.render.Render;
import com.conquestreforged.client.tutorial.Tutorials;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class PaletteScreen
extends CustomCreativeScreen<PaletteContainer> {
    private static final ResourceLocation WHEEL = new ResourceLocation("conquest:textures/gui/picker/wheel.png");
    private static final int EXIT = 256;
    private static final int SIZE = 218;
    private final Screen previous;
    private final PaletteSettings settings = new PaletteSettings();
    private Slot hovered = null;

    public PaletteScreen(Player player, Inventory inventory, PaletteContainer container) {
        this(null, player, inventory, container);
    }

    public PaletteScreen(Screen previous, Player player, Inventory inventory, PaletteContainer container) {
        super(container, inventory, (Component)Component.m_237113_((String)"Palette Screen"));
        this.previous = previous;
        player.f_36096_ = container;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.settings.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.m_169394_((Renderable)this.settings);
        this.resize(this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_());
        Tutorials.openPalette = true;
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.resize(width, height);
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        ((PaletteContainer)this.m_6262_()).updateStyle(this.settings);
        this.setupRender(matrixStack.m_280168_());
        int mx = mouseX - this.f_97735_;
        int my = mouseY - this.f_97736_;
        ((PaletteContainer)this.m_6262_()).visitRadius(mx, my, (slot, depth) -> {
            float scale = slot.getScale(mx, my, this.settings);
            this.renderSlotBackGround(matrixStack, (Slot)slot, slot.getStyle(), depth.floatValue(), scale);
        });
        ((PaletteContainer)this.m_6262_()).visitRadius(mx, my, (slot, depth) -> {
            float scale = slot.getScale(mx, my, this.settings);
            this.renderSlot(matrixStack, (Slot)slot, slot.getStyle(), mx, my, depth.floatValue(), scale);
        });
        ((PaletteContainer)this.m_6262_()).visitCenter(slot -> {
            float scale = slot.getScale(mx, my, this.settings);
            RenderSystem.enableBlend();
            this.renderSlotBackGround(matrixStack, (Slot)slot, slot.getStyle(), 1.0f, scale);
            this.renderSlot(matrixStack, (Slot)slot, slot.getStyle(), mx, my, 1.0f, scale);
        });
        ((PaletteContainer)this.m_6262_()).visitHotbar(slot -> this.renderSlot(matrixStack, (Slot)slot, mx, my, 1.0f, 1.0f));
        this.renderDraggedItem(matrixStack, mx, my, 1.0f, ((PaletteContainer)this.m_6262_()).getDraggedStyle());
        this.tearDownRender(matrixStack.m_280168_());
        this.settings.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280003_(matrixStack, mouseX, mouseY);
    }

    public void m_7286_(GuiGraphics drawContext, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(drawContext);
        Render.drawTexture(WHEEL, drawContext, this.f_97735_, this.f_97736_, 218, 218, 0.0f, 0.0f);
        ((PaletteContainer)this.m_6262_()).getHotbar().renderBackground((Screen)this, drawContext);
    }

    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        super.m_280003_(matrixStack, mouseX, mouseY);
        if (this.f_96541_ == null) {
            return;
        }
        ItemStack display = ((PaletteContainer)this.m_6262_()).m_142621_();
        if (display.m_41619_()) {
            Slot slot;
            this.hovered = slot = ((PaletteContainer)this.m_6262_()).getClosestSlot(mouseX - this.f_97735_, mouseY - this.f_97736_, true);
            if (slot == null) {
                return;
            }
            display = slot.m_7993_();
        }
        if (display.m_41720_() == Items.f_41852_) {
            return;
        }
        int top = this.f_96544_ - 32;
        int left = this.f_96543_ / 2;
        int color = 0xFFFFFF;
        String text = display.m_41786_().getString();
        matrixStack.m_280137_(this.f_96541_.f_91062_, text, left, top, color);
    }

    public boolean m_5534_(char c, int code) {
        if (c >= '1' && c <= '9' && this.hovered != null && this.hovered.m_6657_()) {
            ((PaletteContainer)this.f_97732_).getHotbar().getInventory().m_6836_(c - 49, this.hovered.m_7993_());
            super.sendChanges();
            return true;
        }
        return super.m_5534_(c, code);
    }

    @Override
    protected boolean isContainerSlot(Slot slot) {
        return slot.f_40218_ == ((PaletteContainer)this.m_6262_()).getPaletteInventory();
    }

    public void m_7379_() {
        this.settings.m_7379_();
        if (this.previous != null) {
            this.previous.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        Minecraft.m_91087_().m_91152_(this.previous);
    }

    private void resize(int width, int height) {
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.f_97735_ = (width - 218) / 2;
        this.f_97736_ = (height - 218) / 2;
        ((PaletteContainer)this.m_6262_()).init(this);
    }

    public static boolean closesGui(int key) {
        return key == 256 || key == BindManager.getPaletteBind().m_90861_().m_84873_();
    }
}

