/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette.texture;

import com.conquestreforged.core.util.OptionalValue;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TextureGroup
implements OptionalValue {
    protected static final TextureGroup NONE = new TextureGroup("none");
    private final String name;
    private final LinkedList<ItemStack> itemStacks = new LinkedList();
    private Comparator<Item> order = BY_NAME;
    private static final Comparator<Item> BY_NAME = (i1, i2) -> {
        if (BuiltInRegistries.f_257033_.m_7981_(i1) == null || BuiltInRegistries.f_257033_.m_7981_(i2) == null) {
            return 0;
        }
        return BuiltInRegistries.f_257033_.m_7981_(i1).compareTo(BuiltInRegistries.f_257033_.m_7981_(i2));
    };

    public TextureGroup(String name) {
        this.name = name;
    }

    @Override
    public boolean isAbsent() {
        return this == NONE;
    }

    public String getName() {
        return this.name;
    }

    public void addTo(NonNullList<ItemStack> list) {
        for (ItemStack stack : this.itemStacks) {
            list.add((Object)stack.m_41777_());
        }
    }

    public ItemStack getHead() {
        if (this.itemStacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return this.itemStacks.getFirst().m_41777_();
    }

    public List<ItemStack> getItems() {
        return this.itemStacks;
    }

    public NonNullList<ItemStack> getItemsCopy() {
        NonNullList list = NonNullList.m_122779_();
        this.addTo((NonNullList<ItemStack>)list);
        return list;
    }

    protected void sort(Comparator<Item> order) {
        this.order = order;
        this.itemStacks.sort(TextureGroup.wrap(order));
    }

    protected void add(Item item) {
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            ItemStack current = this.itemStacks.get(i);
            if (this.order.compare(item, current.m_41720_()) >= 0) continue;
            this.itemStacks.add(i, item.m_7968_());
            return;
        }
        this.itemStacks.add(item.m_7968_());
    }

    private static Comparator<ItemStack> wrap(Comparator<Item> comparator) {
        return (s1, s2) -> comparator.compare(s1.m_41720_(), s2.m_41720_());
    }
}

