/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.search;

import com.conquestreforged.client.utils.CreativeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;

public class SearchList
implements GuiEventListener,
NarratableEntry {
    private static final int slotSize = 20;
    private static final int stackSize = 16;
    private static final int stackPad = 2;
    public float x;
    public float y;
    public float scale = 1.0f;
    private int count = 0;
    private int maxRow = 0;
    private final int rows;
    private final int columns;
    private final Slot[] slots;
    private Slot hovered = null;

    public SearchList(int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
        this.slots = new Slot[columns * rows];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                int i = c + r * columns;
                this.slots[i] = new Slot(c, r);
            }
        }
    }

    public int getHeight() {
        if (this.count == 0) {
            return 0;
        }
        return Math.round((float)(this.rows * 20) * this.scale);
    }

    public int getWidth() {
        return Math.round((float)(this.columns * 20) * this.scale);
    }

    public int size() {
        return this.count;
    }

    public int maxSize() {
        return this.rows * this.columns;
    }

    public synchronized void add(ItemStack stack) {
        Slot slot = this.slots[this.count++];
        slot.stack = stack;
        this.maxRow = slot.row;
    }

    public synchronized void clear() {
        this.count = 0;
        this.maxRow = 0;
        for (Slot slot : this.slots) {
            slot.stack = ItemStack.f_41583_;
        }
    }

    public void render(GuiGraphics drawContext, int mx, int my, int width, int height, float tick) {
        this.hovered = null;
        for (Slot slot : this.slots) {
            if (slot.col == 0 && slot.stack.m_41619_() || !slot.fitsOnScreen(width, height)) break;
            slot.render(drawContext.m_280168_(), mx, my);
        }
        if (this.hovered == null) {
            return;
        }
        String name = this.hovered.stack.m_41611_().getString();
        int nameWidth = Minecraft.m_91087_().f_91062_.m_92895_(name);
        int left = width / 2 - nameWidth / 2;
        drawContext.m_280056_(Minecraft.m_91087_().f_91062_, name, left, height - 32, 0xFFFFFF, true);
    }

    public boolean m_6375_(double mx, double my, int button) {
        for (Slot slot : this.slots) {
            if (!slot.click(mx, my)) continue;
            return true;
        }
        return false;
    }

    public void m_93692_(boolean bl) {
    }

    public boolean m_93696_() {
        return false;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean m_142518_() {
        return super.m_142518_();
    }

    private class Slot
    extends GuiGraphics {
        private final int col;
        private final int row;
        private ItemStack stack;

        private Slot(int col, int row) {
            super(Minecraft.m_91087_(), MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256)));
            this.stack = ItemStack.f_41583_;
            this.row = row;
            this.col = col;
        }

        private float left() {
            return SearchList.this.x + (float)(this.col * 20) * SearchList.this.scale;
        }

        private float top() {
            return SearchList.this.y + (float)(this.row * 20) * SearchList.this.scale;
        }

        private boolean mouseOver(double mx, double my) {
            float l = this.left();
            float t = this.top();
            float size = 20.0f * SearchList.this.scale;
            return mx >= (double)l && mx <= (double)(l + size) && my >= (double)t && my <= (double)(t + size);
        }

        private boolean fitsOnScreen(int width, int height) {
            float right = this.left() + 20.0f * SearchList.this.scale;
            float bottom = this.top() + 20.0f * SearchList.this.scale;
            return right < (float)width && bottom < (float)(height - 32);
        }

        private void render(PoseStack matrixStack, double mx, double my) {
            float top = this.top();
            float left = this.left();
            PoseStack posestack = RenderSystem.getModelViewStack();
            posestack.m_85836_();
            posestack.m_252880_(left, top, 0.0f);
            posestack.m_85841_(SearchList.this.scale, SearchList.this.scale, SearchList.this.scale);
            RenderSystem.applyModelViewMatrix();
            if (!this.stack.m_41619_()) {
                this.m_280480_(this.stack, 2, 2);
            }
            posestack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            matrixStack.m_85836_();
            matrixStack.m_252880_(left, top, 0.0f);
            matrixStack.m_85841_(SearchList.this.scale, SearchList.this.scale, SearchList.this.scale);
            this.m_280509_(0, 0, 20, 20, 0x55000000);
            if (this.mouseOver(mx, my)) {
                SearchList.this.hovered = this;
                this.m_280509_(1, 1, 19, 19, 0x55999999);
            }
            matrixStack.m_85849_();
            RenderSystem.enableDepthTest();
        }

        private boolean click(double mx, double my) {
            if (this.mouseOver(mx, my)) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return false;
                }
                if (CreativeUtils.addItemStack(this.stack.m_41777_(), true)) {
                    Minecraft.m_91087_().m_91152_(null);
                    return true;
                }
            }
            return false;
        }
    }
}

