/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.search;

import com.conquestreforged.client.gui.search.SearchList;
import com.conquestreforged.client.gui.search.query.Index;
import com.conquestreforged.client.gui.search.query.Result;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SearchScreen
extends Screen
implements Consumer<String> {
    private static final float scale = 2.0f;
    private static final LazyLoadedValue<Index<ItemStack>> index = new LazyLoadedValue(SearchScreen::buildIndex);
    private final EditBox search;
    private final Index<ItemStack> itemIndex;
    private final SearchList searchList;

    public SearchScreen() {
        super((Component)Component.m_237113_((String)"search"));
        this.search = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, (Component)Component.m_237115_((String)"Search"));
        this.search.m_94151_((Consumer)this);
        this.itemIndex = (Index)index.m_13971_();
        this.searchList = new SearchList(5, 6);
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (!super.m_6375_(mx, my, button)) {
            Minecraft.m_91087_().m_91152_(null);
            return false;
        }
        return true;
    }

    public void m_86600_() {
        super.m_86600_();
        this.check();
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)this.search);
        int centerX = this.f_96543_ / 2;
        this.search.m_252865_(centerX - this.search.m_5711_() / 2);
        this.search.m_253211_(100);
        this.m_7787_(this.searchList);
    }

    public void m_88315_(GuiGraphics drawContext, int mx, int my, float ticks) {
        this.update();
        super.m_280273_(drawContext);
        super.m_88315_(drawContext, mx, my, ticks);
        this.searchList.render(drawContext, mx, my, this.f_96543_, this.f_96544_, ticks);
    }

    @Override
    public void accept(String term) {
        this.searchList.clear();
        ((Stream)this.itemIndex.parallelSearch(term, this.searchList.maxSize()).sequential()).map(Result::getResult).forEach(this.searchList::add);
        if (this.searchList.size() == 0) {
            this.search.m_253211_(this.f_96544_ / 2 - this.search.m_93694_() / 2);
        } else {
            this.search.m_253211_(20);
        }
    }

    private void update() {
        int pad = 8;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int guiHeight = this.search.m_93694_() + pad + this.searchList.getHeight();
        this.m_7522_((GuiEventListener)this.search);
        this.search.m_93692_(true);
        this.search.m_252865_(centerX - this.search.m_5711_() / 2);
        this.search.m_253211_(Math.max(10, centerY - guiHeight / 2));
        this.searchList.x = (float)centerX - (float)this.searchList.getWidth() / 2.0f;
        this.searchList.y = this.search.m_252907_() + this.search.m_93694_() + pad;
        this.searchList.scale = 2.0f;
    }

    private void check() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !player.m_150110_().f_35937_) {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    private static Index<ItemStack> buildIndex() {
        Index.Builder<ItemStack> builder = Index.builder();
        for (Item item : BuiltInRegistries.f_257033_.m_123024_().toList()) {
            if (item == Items.f_41852_) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            builder.with(stack, stack.m_41611_().getString(), SearchScreen.getTags(stack));
        }
        return builder.build();
    }

    private static Collection<String> getTags(ItemStack item) {
        LinkedList<String> tags = new LinkedList<String>();
        tags.add(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135815_());
        List itemTags = item.m_204131_().collect(Collectors.toList());
        for (TagKey tag : itemTags) {
            tags.add(tag.f_203868_().m_135815_());
        }
        return tags;
    }
}

