/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.tutorial;

import com.conquestreforged.client.gui.dependency.Dependency;
import com.conquestreforged.client.gui.dependency.DependencyList;
import com.conquestreforged.client.gui.dependency.screen.DependencyScreen;
import com.conquestreforged.client.gui.intro.IntroScreen;
import com.conquestreforged.client.tutorial.Tutorials;
import com.conquestreforged.core.config.ConfigBuildEvent;
import com.conquestreforged.core.config.section.ConfigSection;
import com.conquestreforged.core.config.section.ConfigSectionSpec;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TutorialRenderEvent {
    private final ConfigSection section;
    private final DependencyList dependencies = DependencyList.load();
    private boolean hasRenderedIntro = false;
    private boolean hasRenderedDependency = false;

    public TutorialRenderEvent(ConfigSection section) {
        this.section = section;
    }

    @SubscribeEvent
    public static void config(ConfigBuildEvent event) {
        try (ConfigSectionSpec spec = event.client("tutorials", new String[0]);){
            spec.getBuilder().define("ignore_dependencies", false).next();
            spec.getBuilder().define("ignore_intro", false).next();
            spec.getBuilder().define("using_modpack", false).next();
            MinecraftForge.EVENT_BUS.register((Object)new TutorialRenderEvent(spec.getSection()));
        }
    }

    @SubscribeEvent
    public void render(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof TitleScreen) {
            List<Dependency> missing = this.dependencies.getMissingDependencies();
            IntroScreen introScreen = new IntroScreen(event.getScreen(), this.section);
            DependencyScreen dependencyScreen = new DependencyScreen(event.getScreen(), this.section, missing);
            DependencyScreen dependencyScreen2 = new DependencyScreen(introScreen, this.section, missing);
            if (this.section.getOrElse("ignore_dependencies", Boolean.valueOf(false)) != false && this.section.getOrElse("ignore_intro", Boolean.valueOf(false)) != false || missing.isEmpty() && Tutorials.intro || Tutorials.dependencies && Tutorials.intro) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            if (!Tutorials.intro) {
                if (this.section.getOrElse("ignore_intro", Boolean.valueOf(false)).booleanValue()) {
                    if (!missing.isEmpty()) {
                        Minecraft.m_91087_().m_91152_((Screen)dependencyScreen);
                    }
                    if (Tutorials.dependencies || missing.isEmpty()) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                } else if (this.section.getOrElse("ignore_dependencies", Boolean.valueOf(false)).booleanValue() || missing.isEmpty()) {
                    Minecraft.m_91087_().m_91152_((Screen)introScreen);
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)dependencyScreen2);
                }
            }
        }
    }
}

