/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block;

import com.conquestreforged.content.blocks.block.VerticalQuarter;
import com.conquestreforged.content.blocks.util.PlacementHelper;
import com.conquestreforged.core.asset.annotation.Assets;
import com.conquestreforged.core.asset.annotation.Model;
import com.conquestreforged.core.asset.annotation.State;
import com.conquestreforged.core.block.base.WaterloggedHorizontalDirectionalShape;
import com.conquestreforged.core.block.builder.Props;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

@Assets(state=@State(name="%s_vertical_quarter", template="parent_vertical_quarter"), item=@Model(name="item/%s_vertical_corner_slab", parent="block/%s_vertical_corner_slab_left", template="item/parent_slab_corner"), block={@Model(name="block/%s_vertical_corner_slab_left", template="block/parent_vertical_corner_slab_left"), @Model(name="block/%s_vertical_corner_slab_bottom_left", template="block/parent_vertical_corner_slab_bottom_left"), @Model(name="block/%s_vertical_corner_slab_right", template="block/parent_vertical_corner_slab_right"), @Model(name="block/%s_vertical_corner_slab_bottom_right", template="block/parent_vertical_corner_slab_bottom_right")})
public class VerticalQuarterHinged
extends WaterloggedHorizontalDirectionalShape {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layer", (int)1, (int)4);
    protected Block fullBlock;

    public VerticalQuarterHinged(Props props) {
        super(props.toSettings());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.fullBlock = props.getParent().m_60734_();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluid = context.m_43725_().m_6425_(blockpos);
        Direction facingHorizontal = context.m_8125_().m_122424_();
        BlockState state2 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)facingHorizontal)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            if (i == 4) {
                return this.fullBlock.m_49966_();
            }
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(4, i + 1)));
        }
        return (BlockState)state2.m_61124_(HINGE, (Comparable)this.getHingeSide(facingHorizontal, blockpos, context));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (context.m_43722_().m_41720_() == this.m_5456_() && i <= 4) {
            if (PlacementHelper.replacingClickedOnBlock(context)) {
                return context.m_43719_() == state.m_61143_((Property)DIRECTION) || context.m_43719_() == ((Direction)state.m_61143_((Property)DIRECTION)).m_122428_();
            }
            return true;
        }
        return false;
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case FRONT_BACK: {
                switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                    case NORTH: 
                    case SOUTH: {
                        return (BlockState)state.m_61122_(HINGE);
                    }
                }
                return super.m_6943_(state, mirrorIn);
            }
            case LEFT_RIGHT: {
                switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                    case EAST: 
                    case WEST: {
                        return (BlockState)state.m_61122_(HINGE);
                    }
                }
                return super.m_6943_(state, mirrorIn);
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    private DoorHingeSide getHingeSide(Direction facing, BlockPos pos, BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_8125_();
        int j = direction.m_122429_();
        int k = direction.m_122431_();
        Vec3 vec3d = context.m_43720_();
        double d = vec3d.f_82479_ - (double)blockPos.m_123341_();
        double e = vec3d.f_82481_ - (double)blockPos.m_123343_();
        return !(j < 0 && e < 0.5 || j > 0 && e > 0.5 || k < 0 && d > 0.5 || k > 0 && d < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    @Override
    protected void addProperties(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{HINGE}).m_61104_(new Property[]{LAYERS});
    }

    @Override
    public VoxelShape getShape(BlockState state) {
        if (state.m_61143_(HINGE) == DoorHingeSide.LEFT) {
            switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                default: {
                    return VerticalQuarter.NORTH_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
                }
                case SOUTH: {
                    return VerticalQuarter.SOUTH_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
                }
                case WEST: {
                    return VerticalQuarter.WEST_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
                }
                case EAST: 
            }
            return VerticalQuarter.EAST_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
        }
        switch ((Direction)state.m_61143_((Property)DIRECTION)) {
            default: {
                return VerticalQuarter.EAST_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
            }
            case SOUTH: {
                return VerticalQuarter.WEST_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
            }
            case WEST: {
                return VerticalQuarter.NORTH_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
            }
            case EAST: 
        }
        return VerticalQuarter.SOUTH_SHAPE[(Integer)state.m_61143_((Property)LAYERS) - 1];
    }
}

