/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.decor;

import com.conquestrefabricated.core.block.properties.ModBlockProperties;
import com.conquestreforged.content.blocks.CustomOffsetType;
import com.conquestreforged.content.blocks.block.directional.HorizontalDirectional;
import com.conquestreforged.content.blocks.tileentity.TileEntityTypes;
import com.conquestreforged.content.blocks.tileentity.loom.LoomBlockEntity;
import com.conquestreforged.content.blocks.util.PlacementHelper;
import com.conquestreforged.content.items.init.ItemCommonInit;
import com.conquestreforged.core.asset.annotation.ItemDescription;
import com.conquestreforged.core.block.builder.Props;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ItemDescription(description="loom_toggle_4")
public class Loom
extends HorizontalDirectional
implements EntityBlock {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)1, (int)3);
    public static final IntegerProperty POSITION = IntegerProperty.m_61631_((String)"position", (int)1, (int)4);
    public static final BooleanProperty HAS_THREAD = BooleanProperty.m_61465_((String)"has_thread");
    public static final BooleanProperty OFFSET_TOGGLE = ModBlockProperties.OFFSET_TOGGLE;

    public Loom(Props props) {
        super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HAS_THREAD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OFFSET_TOGGLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    @Override
    protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE, POSITION, HAS_THREAD, OFFSET_TOGGLE});
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isSlab = PlacementHelper.isFacingSlab(context);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1))).m_61124_((Property)POSITION, (Comparable)Integer.valueOf(1))).m_61124_((Property)HAS_THREAD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_().equals(Items.f_42751_)) {
            return InteractionResult.PASS;
        }
        if (player.m_21120_(hand).m_41720_().equals(ItemCommonInit.getMallet())) {
            level.m_7731_(blockPos, (BlockState)state.m_61122_((Property)SIZE), 3);
            return InteractionResult.SUCCESS;
        }
        LoomBlockEntity blockEntity = (LoomBlockEntity)level.m_7702_(blockPos);
        if (blockEntity != null) {
            String itemId = player.m_21120_(hand).m_41720_().toString();
            if (itemId.contains("red_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:red_canvas");
            }
            if (itemId.contains("black_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:black_canvas");
            }
            if (itemId.contains("light_gray_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:light_gray_canvas");
            }
            if (itemId.contains("gray_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:gray_canvas");
            }
            if (itemId.contains("white_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:white_canvas");
            }
            if (itemId.contains("brown_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:brown_canvas");
            }
            if (itemId.contains("yellow_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:yellow_canvas");
            }
            if (itemId.contains("orange_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:orange_canvas");
            }
            if (itemId.contains("pink_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:pink_canvas");
            }
            if (itemId.contains("magenta_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:magenta_canvas");
            }
            if (itemId.contains("purple_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:purple_canvas");
            }
            if (itemId.contains("light_blue_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:light_blue_canvas");
            }
            if (itemId.contains("blue_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:blue_canvas");
            }
            if (itemId.contains("cyan_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:cyan_canvas");
            }
            if (itemId.contains("green_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:green_canvas");
            }
            if (itemId.contains("lime_canvas")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:lime_canvas");
            }
            if (itemId.contains("baotuo_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:baotuo_rug");
            }
            if (itemId.contains("berber_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:berber_rug");
            }
            if (itemId.contains("black_persian_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:black_persian_rug");
            }
            if (itemId.contains("blue_nain_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:blue_nain_rug");
            }
            if (itemId.contains("brown_oriental_carpet")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:brown_oriental_carpet");
            }
            if (itemId.contains("celtic_knot_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:celtic_knot_rug");
            }
            if (itemId.contains("kashmiri_carpet")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:kashmiri_carpet");
            }
            if (itemId.contains("kazakh_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:kazakh_rug");
            }
            if (itemId.contains("kilim_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:kilim_rug");
            }
            if (itemId.contains("nahavand_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:nahavand_rug");
            }
            if (itemId.contains("red_and_blue_sarouk_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:red_and_blue_sarouk_rug");
            }
            if (itemId.contains("red_oriental_carpet")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:red_oriental_carpet");
            }
            if (itemId.contains("red_pazyryk_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:red_pazyryk_rug");
            }
            if (itemId.contains("shirishabad_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:shirishabad_rug");
            }
            if (itemId.contains("william_morris_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:william_morris_rug");
            }
            if (itemId.contains("yellow_red_persian_rug")) {
                return this.setProduct(level, blockPos, player, state, hand, blockEntity, "conquest:yellow_red_persian_rug");
            }
            if (player.m_6144_()) {
                if (!player.m_150110_().f_35937_) {
                    return this.dropProduct(level, blockPos, state, blockEntity);
                }
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)HAS_THREAD, (Comparable)Boolean.valueOf(false)), 3);
                blockEntity.setProduct("");
                blockEntity.m_6596_();
                level.m_7260_(blockPos, state, state, 3);
                return InteractionResult.SUCCESS;
            }
            level.m_7731_(blockPos, (BlockState)state.m_61122_((Property)POSITION), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LoomBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityTypes.LOOM ? (world1, pos, state1, blockEntity) -> ((LoomBlockEntity)blockEntity).tick(world1, pos) : null;
    }

    private InteractionResult setProduct(Level level, BlockPos blockPos, Player player, BlockState state, InteractionHand hand, LoomBlockEntity blockEntity, String product) {
        if (!player.m_150110_().f_35937_) {
            this.dropProduct(level, blockPos, state, blockEntity);
            player.m_21120_(hand).m_41774_(1);
        }
        level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)HAS_THREAD, (Comparable)Boolean.valueOf(true)), 3);
        blockEntity.setProduct(product);
        blockEntity.m_6596_();
        level.m_7260_(blockPos, state, state, 3);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult dropProduct(Level level, BlockPos blockPos, BlockState state, LoomBlockEntity blockEntity) {
        String product = blockEntity.getProduct();
        if (product != null && !product.isEmpty()) {
            ItemStack itemToSpawn = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(product)), 1);
            Vec3 spawnPos = Vec3.m_82512_((Vec3i)blockPos).m_82520_(0.0, 1.3, 0.0);
            ItemEntity itemEntity = new ItemEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, itemToSpawn);
            itemEntity.m_32010_(10);
            level.m_7967_((Entity)itemEntity);
            level.m_5594_(null, blockPos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)HAS_THREAD, (Comparable)Boolean.valueOf(false)), 3);
            blockEntity.setProduct("");
            blockEntity.m_6596_();
            level.m_7260_(blockPos, state, state, 3);
        }
        return InteractionResult.SUCCESS;
    }
}

