/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.directional;

import com.conquestreforged.content.blocks.util.Interactions;
import com.conquestreforged.content.blocks.util.PlacementHelper;
import com.conquestreforged.core.asset.annotation.Assets;
import com.conquestreforged.core.asset.annotation.ItemDescription;
import com.conquestreforged.core.asset.annotation.Model;
import com.conquestreforged.core.asset.annotation.State;
import com.conquestreforged.core.block.base.HorizontalDirectionalShape;
import com.conquestreforged.core.block.base.Shape;
import com.conquestreforged.core.block.base.WaterloggedHorizontalDirectionalShape;
import com.conquestreforged.core.block.builder.Props;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Half
extends Shape {
    public static final EnumProperty<net.minecraft.world.level.block.state.properties.Half> TYPE_UPDOWN = EnumProperty.m_61587_((String)"type", net.minecraft.world.level.block.state.properties.Half.class);
    private static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public Half(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.BOTTOM));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state2 = (BlockState)this.m_49966_().m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.BOTTOM);
        Direction facing = context.m_43719_();
        return !(facing == Direction.DOWN || facing != Direction.UP && context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5) ? state2 : (BlockState)state2.m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.TOP);
    }

    protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE_UPDOWN});
    }

    @Override
    public VoxelShape getShape(BlockState state) {
        if (state.m_61143_(TYPE_UPDOWN) == net.minecraft.world.level.block.state.properties.Half.BOTTOM) {
            return BOTTOM_SHAPE;
        }
        return TOP_SHAPE;
    }

    public static class DirectionalWaterlogged
    extends WaterloggedHorizontalDirectionalShape {
        private final List<VoxelShape> hitBox;

        public DirectionalWaterlogged(Props props) {
            super(props.toSettings());
            this.hitBox = props.getOrDefault("hitBox", List.class, Arrays.asList(BOTTOM_SHAPE, TOP_SHAPE));
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public BlockState m_5573_(BlockPlaceContext context) {
            FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
            Direction facingHorizontal = context.m_8125_().m_122424_();
            BlockState state2 = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)facingHorizontal)).m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
            Direction facing = context.m_43719_();
            return !(facing == Direction.DOWN || facing != Direction.UP && context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5) ? state2 : (BlockState)state2.m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.TOP);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> container) {
            container.m_61104_(new Property[]{TYPE_UPDOWN});
        }

        @Override
        public VoxelShape getShape(BlockState state) {
            int shapesAmount = this.hitBox.size();
            switch (shapesAmount) {
                default: {
                    return this.hitBox.get(0);
                }
                case 2: {
                    if (state.m_61143_(TYPE_UPDOWN) == net.minecraft.world.level.block.state.properties.Half.BOTTOM) {
                        return this.hitBox.get(0);
                    }
                    return this.hitBox.get(1);
                }
                case 8: 
            }
            if (state.m_61143_(TYPE_UPDOWN) == net.minecraft.world.level.block.state.properties.Half.BOTTOM) {
                return switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                    case Direction.EAST -> this.hitBox.get(1);
                    case Direction.SOUTH -> this.hitBox.get(2);
                    case Direction.WEST -> this.hitBox.get(3);
                    default -> this.hitBox.get(0);
                };
            }
            return switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                case Direction.EAST -> this.hitBox.get(5);
                case Direction.SOUTH -> this.hitBox.get(6);
                case Direction.WEST -> this.hitBox.get(7);
                default -> this.hitBox.get(4);
            };
        }

        @Assets(state=@State(name="%s_slab_directional", template="parent_slab"), item=@Model(name="item/%s_slab_directional", parent="block/%s_slab", template="item/acacia_slab"), block={@Model(name="block/%s_slab_directional", template="block/orientable")})
        public static class FamilyVariant
        extends DirectionalWaterlogged {
            public FamilyVariant(Props properties) {
                super(properties);
            }
        }
    }

    public static class Directional
    extends HorizontalDirectionalShape {
        public Directional(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.BOTTOM));
        }

        @Override
        public VoxelShape m_6079_(BlockState state, BlockGetter world, BlockPos pos) {
            return this.getShape(state);
        }

        @Override
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facingHorizontal = context.m_8125_().m_122424_();
            BlockState state2 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)facingHorizontal)).m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.BOTTOM);
            Direction facing = context.m_43719_();
            return !(facing == Direction.DOWN || facing != Direction.UP && context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5) ? state2 : (BlockState)state2.m_61124_(TYPE_UPDOWN, (Comparable)net.minecraft.world.level.block.state.properties.Half.TOP);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> container) {
            container.m_61104_(new Property[]{TYPE_UPDOWN});
        }

        @Override
        public VoxelShape getShape(BlockState state) {
            if (state.m_61143_(TYPE_UPDOWN) == net.minecraft.world.level.block.state.properties.Half.BOTTOM) {
                return BOTTOM_SHAPE;
            }
            return TOP_SHAPE;
        }

        @ItemDescription(description="toggle_4")
        public static class Toggle4
        extends Directional {
            public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)4);

            public Toggle4(BlockBehaviour.Properties properties) {
                super(properties);
            }

            @Override
            protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
                super.addProperties(builder);
                builder.m_61104_(new Property[]{TOGGLE});
            }

            public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
                return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
            }
        }

        @ItemDescription(description="toggle_3")
        public static class Toggle3
        extends Directional {
            public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)3);

            public Toggle3(BlockBehaviour.Properties properties) {
                super(properties);
            }

            @Override
            protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
                super.addProperties(builder);
                builder.m_61104_(new Property[]{TOGGLE});
            }

            public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
                return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
            }

            @ItemDescription(description="toggle_3")
            public static class Corner
            extends Toggle3 {
                public Corner(BlockBehaviour.Properties props) {
                    super(props);
                }

                @Override
                public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
                    return PlacementHelper.mirrorCornerDirection(state, mirrorIn, DIRECTION, (x$0, x$1) -> super.m_6943_((BlockState)x$0, (Mirror)x$1));
                }
            }
        }

        @ItemDescription(description="toggle_2")
        public static class Toggle2
        extends Directional {
            public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)2);

            public Toggle2(BlockBehaviour.Properties properties) {
                super(properties);
            }

            @Override
            protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
                super.addProperties(builder);
                builder.m_61104_(new Property[]{TOGGLE});
            }

            public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
                return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
            }

            @ItemDescription(description="toggle_2")
            public static class Corner
            extends Toggle2 {
                public Corner(BlockBehaviour.Properties props) {
                    super(props);
                }

                @Override
                public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
                    return PlacementHelper.mirrorCornerDirection(state, mirrorIn, DIRECTION, (x$0, x$1) -> super.m_6943_((BlockState)x$0, (Mirror)x$1));
                }
            }
        }
    }
}

