/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.init;

import com.conquestreforged.content.blocks.group.ModGroups;
import com.conquestreforged.core.block.factory.TypeList;
import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyRegistry;
import com.conquestreforged.core.item.family.block.BlockFamily;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="conquest", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlockFamilyInit {
    private static final Gson GSON = new Gson();

    public static void init() {
        BlockFamilyInit.setRoot("conquest:limestone_cobble_small_arch", Blocks.f_50652_, Blocks.f_50157_, Blocks.f_50274_);
        BlockFamilyInit.setRoot("conquest:mossy_limestone_cobble_small_arch", Blocks.f_50079_, Blocks.f_50633_, Blocks.f_50275_);
        BlockFamilyInit.setRoot("conquest:limestone_brick_small_arch", Blocks.f_50222_, Blocks.f_50194_, Blocks.f_50609_);
        BlockFamilyInit.setRoot("conquest:mossy_limestone_brick_small_arch", Blocks.f_50223_, Blocks.f_50631_, Blocks.f_50607_);
        BlockFamilyInit.setRoot("conquest:cracked_limestone_brick_small_arch", Blocks.f_50224_);
        BlockFamilyInit.setRoot("conquest:large_andesite_masonry_small_arch", Blocks.f_50387_, Blocks.f_50641_);
        BlockFamilyInit.setRoot("conquest:large_light_limestone_brick_small_arch", Blocks.f_50281_, Blocks.f_50632_);
        BlockFamilyInit.setRoot("conquest:large_granite_brick_small_arch", Blocks.f_50175_, Blocks.f_50629_);
        BlockFamilyInit.setRoot("conquest:clay_brick_small_arch", Blocks.f_50076_, Blocks.f_50193_, Blocks.f_50604_);
        BlockFamilyInit.setRoot("conquest:concrete_wall_small_arch", Blocks.f_50498_);
        BlockFamilyInit.setRoot("conquest:red_sandstone_cobble_small_arch", Blocks.f_50394_, Blocks.f_50397_, Blocks.f_50606_);
        BlockFamilyInit.setRoot("conquest:sandstone_small_arch", Blocks.f_50062_, Blocks.f_50263_, Blocks.f_50613_);
        BlockFamilyInit.setRoot("conquest:marble_brick_small_arch", Blocks.f_50333_, Blocks.f_50284_);
        BlockFamilyInit.setRoot("conquest:prismarine_brick_small_arch", Blocks.f_50378_, Blocks.f_50381_);
        BlockFamilyInit.setRoot("conquest:dark_prismarine_small_arch", Blocks.f_50379_, Blocks.f_50382_);
        BlockFamilyInit.setRoot("conquest:white_concrete_powder_layer", Blocks.f_50506_);
        BlockFamilyInit.setRoot("conquest:white_concrete_small_arch", Blocks.f_50542_);
        BlockFamilyInit.setRoot("conquest:orange_concrete_powder_layer", Blocks.f_50507_);
        BlockFamilyInit.setRoot("conquest:orange_concrete_small_arch", Blocks.f_50543_);
        BlockFamilyInit.setRoot("conquest:magenta_concrete_powder_layer", Blocks.f_50508_);
        BlockFamilyInit.setRoot("conquest:light_blue_concrete_powder_layer", Blocks.f_50509_);
        BlockFamilyInit.setRoot("conquest:light_blue_concrete_small_arch", Blocks.f_50545_);
        BlockFamilyInit.setRoot("conquest:yellow_concrete_powder_layer", Blocks.f_50510_);
        BlockFamilyInit.setRoot("conquest:yellow_concrete_small_arch", Blocks.f_50494_);
        BlockFamilyInit.setRoot("conquest:lime_concrete_powder_layer", Blocks.f_50511_);
        BlockFamilyInit.setRoot("conquest:pink_concrete_powder_layer", Blocks.f_50512_);
        BlockFamilyInit.setRoot("conquest:pink_concrete_small_arch", Blocks.f_50496_);
        BlockFamilyInit.setRoot("conquest:gray_concrete_powder_layer", Blocks.f_50513_);
        BlockFamilyInit.setRoot("conquest:gray_concrete_small_arch", Blocks.f_50497_);
        BlockFamilyInit.setRoot("conquest:light_gray_concrete_powder_layer", Blocks.f_50514_);
        BlockFamilyInit.setRoot("conquest:cyan_concrete_powder_layer", Blocks.f_50515_);
        BlockFamilyInit.setRoot("conquest:purple_concrete_powder_layer", Blocks.f_50516_);
        BlockFamilyInit.setRoot("conquest:purple_concrete_small_arch", Blocks.f_50500_);
        BlockFamilyInit.setRoot("conquest:black_concrete_small_arch", Blocks.f_50505_);
        BlockFamilyInit.setRoot("conquest:blue_concrete_powder_layer", Blocks.f_50517_);
        BlockFamilyInit.setRoot("conquest:brown_concrete_powder_layer", Blocks.f_50518_);
        BlockFamilyInit.setRoot("conquest:brown_concrete_small_arch", Blocks.f_50502_);
        BlockFamilyInit.setRoot("conquest:green_concrete_small_arch", Blocks.f_50503_);
        BlockFamilyInit.setRoot("conquest:green_concrete_powder_layer", Blocks.f_50519_);
        BlockFamilyInit.setRoot("conquest:red_concrete_powder_layer", Blocks.f_50573_);
        BlockFamilyInit.setRoot("conquest:black_concrete_powder_layer", Blocks.f_50574_);
        BlockFamilyInit.setRoot("conquest:dirty_blue_clay_beaver_tail_tile_stairs", Blocks.f_50290_);
        BlockFamilyInit.setRoot("conquest:blue_clay_beaver_tail_tile_stairs", Blocks.f_50298_);
        BlockFamilyInit.setRoot("conquest:old_slate_roof_tile_stairs", Blocks.f_50296_);
        BlockFamilyInit.setRoot("conquest:overgrown_green_clay_shingle_stairs", Blocks.f_50292_);
        BlockFamilyInit.setRoot("conquest:green_clay_shingle_stairs", Blocks.f_50300_);
        BlockFamilyInit.setRoot("conquest:pink_clay_tile_stairs", Blocks.f_50293_);
        BlockFamilyInit.setRoot("conquest:bundled_hay_slab", Blocks.f_50335_);
        BlockFamilyInit.setRoot("conquest:bamboo_mosaic_slab", Blocks.f_244489_, Blocks.f_244193_);
        BlockFamilyInit.setRoot("conquest:bamboo_wood_plank_small_window", Blocks.f_244477_, Blocks.f_243755_, Blocks.f_244641_, Blocks.f_244313_, Blocks.f_244625_, Blocks.f_244183_, Blocks.f_244433_, Blocks.f_244091_);
        BlockFamilyInit.setRoot("conquest:cherry_wood_plank_small_window", Blocks.f_271304_, Blocks.f_271206_, Blocks.f_271219_, Blocks.f_271274_, Blocks.f_271396_, Blocks.f_271227_, Blocks.f_271516_, Blocks.f_271116_);
        BlockFamilyInit.setRoot("conquest:mangrove_wood_plank_small_window", Blocks.f_220865_, Blocks.f_220848_, Blocks.f_220852_, Blocks.f_220850_, Blocks.f_220846_, Blocks.f_220840_, Blocks.f_220841_, Blocks.f_244485_);
        BlockFamilyInit.setRoot("conquest:oak_wood_plank_small_window", Blocks.f_50705_, Blocks.f_50086_, Blocks.f_50132_, Blocks.f_50192_, Blocks.f_50251_, Blocks.f_50167_, Blocks.f_50095_, Blocks.f_244319_);
        BlockFamilyInit.setRoot("conquest:spruce_wood_plank_small_window", Blocks.f_50741_, Blocks.f_50269_, Blocks.f_50479_, Blocks.f_50474_, Blocks.f_50252_, Blocks.f_50168_, Blocks.f_50149_, Blocks.f_244633_);
        BlockFamilyInit.setRoot("conquest:acacia_wood_plank_small_window", Blocks.f_50744_, Blocks.f_50372_, Blocks.f_50482_, Blocks.f_50477_, Blocks.f_50308_, Blocks.f_50171_, Blocks.f_50151_, Blocks.f_243716_);
        BlockFamilyInit.setRoot("conquest:birch_wood_plank_small_window", Blocks.f_50742_, Blocks.f_50270_, Blocks.f_50480_, Blocks.f_50475_, Blocks.f_50253_, Blocks.f_50169_, Blocks.f_50150_, Blocks.f_243890_);
        BlockFamilyInit.setRoot("conquest:rough_palm_wood_plank_small_window", Blocks.f_50743_, Blocks.f_50271_, Blocks.f_50481_, Blocks.f_50476_, Blocks.f_50254_, Blocks.f_50170_, Blocks.f_50152_, Blocks.f_244263_);
        BlockFamilyInit.setRoot("conquest:dark_oak_wood_plank_small_window", Blocks.f_50745_, Blocks.f_50373_, Blocks.f_50483_, Blocks.f_50478_, Blocks.f_50309_, Blocks.f_50172_, Blocks.f_243960_);
        BlockFamilyInit.setRoot("conquest:oak_wood_beam_wall", Blocks.f_50010_, Blocks.f_50044_);
        BlockFamilyInit.setRoot("conquest:spruce_wood_beam_wall", Blocks.f_50005_, Blocks.f_50045_);
        BlockFamilyInit.setRoot("conquest:birch_wood_beam_wall", Blocks.f_50006_, Blocks.f_50046_);
        BlockFamilyInit.setRoot("conquest:palm_wood_beam_wall", Blocks.f_50007_, Blocks.f_50047_);
        BlockFamilyInit.setRoot("conquest:acacia_wood_beam_wall", Blocks.f_50008_, Blocks.f_50048_);
        BlockFamilyInit.setRoot("conquest:dark_oak_wood_beam_wall", Blocks.f_50009_, Blocks.f_50049_);
        BlockFamilyInit.setRoot("conquest:cherry_wood_beam_wall", Blocks.f_271326_, Blocks.f_271145_);
        BlockFamilyInit.setRoot("conquest:mangrove_wood_beam_wall", Blocks.f_220835_, Blocks.f_220837_);
        BlockFamilyInit.setRoot("conquest:bamboo_wood_beam_wall", Blocks.f_256740_);
        BlockFamilyInit.setRoot("conquest:green_bamboo_wood_beam_wall", Blocks.f_256831_);
        BlockFamilyInit.setRoot("conquest:fancy_stone_column_vertical_slab", Blocks.f_50225_);
        BlockFamilyInit.setRoot("conquest:iron_block_arrowslit", Blocks.f_50075_);
        BlockFamilyInit.setRoot("conquest:carbonite_block_vertical_slab", Blocks.f_50499_);
        BlockFamilyInit.setRoot("conquest:carbonite_paneling_small_arch", Blocks.f_50492_);
        BlockFamilyInit.setRoot("conquest:carbonite_pillar_vertical_slab", Blocks.f_50441_);
        BlockFamilyInit.setRoot("conquest:end_stone_brick_small_arch", Blocks.f_50443_, Blocks.f_50634_, Blocks.f_50614_);
        BlockFamilyInit.setRoot("conquest:old_rusted_metal_tile_arrowslit", Blocks.f_50197_, Blocks.f_50198_);
        BlockFamilyInit.setRoot("conquest:old_rusted_metal_block_arrowslit", Blocks.f_50452_, Blocks.f_50640_);
        BlockFamilyInit.setRoot("conquest:red_painted_angled_tile_slab", Blocks.f_50544_);
        BlockFamilyInit.setRoot("conquest:engraved_red_sandstone_pillar_vertical_slab", Blocks.f_50395_);
        BlockFamilyInit.setRoot("conquest:red_sandstone_pillar_vertical_slab", Blocks.f_50396_);
        BlockFamilyInit.setRoot("conquest:smooth_sandstone_column_vertical_slab", Blocks.f_50064_);
        BlockFamilyInit.setRoot("conquest:sandstone_bordered_stucco_vertical_slab", Blocks.f_50063_);
        BlockFamilyInit.setRoot("conquest:chiseled_polished_parian_marble_design_vertical_slab", Blocks.f_50282_);
        BlockFamilyInit.setRoot("conquest:polished_parian_marble_column_vertical_slab", Blocks.f_50283_);
        BlockFamilyInit.setRoot("conquest:worn_magenta_plaster_small_arch", Blocks.f_50289_);
        BlockFamilyInit.setRoot("conquest:worn_light_gray_plaster_small_arch", Blocks.f_50295_);
        BlockFamilyInit.setRoot("conquest:worn_purple_plaster_small_arch", Blocks.f_50297_);
        BlockFamilyInit.setRoot("conquest:blue_painted_wall_small_arch", Blocks.f_50501_);
        BlockFamilyInit.setRoot("conquest:green_painted_wall_small_arch", Blocks.f_50495_);
        BlockFamilyInit.setRoot("conquest:red_painted_wall_small_arch", Blocks.f_50504_);
        BlockFamilyInit.setRoot("conquest:white_stained_glass_vertical_slab", Blocks.f_50147_);
        BlockFamilyInit.setRoot("conquest:orange_stained_glass_vertical_slab", Blocks.f_50148_);
        BlockFamilyInit.setRoot("conquest:magenta_stained_glass_vertical_slab", Blocks.f_50202_);
        BlockFamilyInit.setRoot("conquest:light_blue_stained_glass_vertical_slab", Blocks.f_50203_);
        BlockFamilyInit.setRoot("conquest:yellow_stained_glass_vertical_slab", Blocks.f_50204_);
        BlockFamilyInit.setRoot("conquest:lime_stained_glass_vertical_slab", Blocks.f_50205_);
        BlockFamilyInit.setRoot("conquest:pink_stained_glass_vertical_slab", Blocks.f_50206_);
        BlockFamilyInit.setRoot("conquest:gray_stained_glass_vertical_slab", Blocks.f_50207_);
        BlockFamilyInit.setRoot("conquest:light_gray_stained_glass_vertical_slab", Blocks.f_50208_);
        BlockFamilyInit.setRoot("conquest:cyan_stained_glass_vertical_slab", Blocks.f_50209_);
        BlockFamilyInit.setRoot("conquest:purple_stained_glass_vertical_slab", Blocks.f_50210_);
        BlockFamilyInit.setRoot("conquest:blue_stained_glass_vertical_slab", Blocks.f_50211_);
        BlockFamilyInit.setRoot("conquest:brown_stained_glass_vertical_slab", Blocks.f_50212_);
        BlockFamilyInit.setRoot("conquest:green_stained_glass_vertical_slab", Blocks.f_50213_);
        BlockFamilyInit.setRoot("conquest:red_stained_glass_vertical_slab", Blocks.f_50214_);
        BlockFamilyInit.setRoot("conquest:black_stained_glass_vertical_slab", Blocks.f_50215_);
        BlockFamilyInit.setRoot("conquest:circular_glass_1_vertical_slab", Blocks.f_50058_);
        BlockFamilyInit.setRoot("conquest:white_wool_slab", Blocks.f_50041_);
        BlockFamilyInit.setRoot("conquest:orange_wool_slab", Blocks.f_50042_);
        BlockFamilyInit.setRoot("conquest:magenta_wool_slab", Blocks.f_50096_);
        BlockFamilyInit.setRoot("conquest:light_blue_wool_slab", Blocks.f_50097_);
        BlockFamilyInit.setRoot("conquest:yellow_wool_slab", Blocks.f_50098_);
        BlockFamilyInit.setRoot("conquest:lime_wool_slab", Blocks.f_50099_);
        BlockFamilyInit.setRoot("conquest:pink_wool_slab", Blocks.f_50100_);
        BlockFamilyInit.setRoot("conquest:gray_wool_slab", Blocks.f_50101_);
        BlockFamilyInit.setRoot("conquest:light_gray_wool_slab", Blocks.f_50102_);
        BlockFamilyInit.setRoot("conquest:cyan_wool_slab", Blocks.f_50103_);
        BlockFamilyInit.setRoot("conquest:purple_wool_slab", Blocks.f_50104_);
        BlockFamilyInit.setRoot("conquest:blue_wool_slab", Blocks.f_50105_);
        BlockFamilyInit.setRoot("conquest:brown_wool_slab", Blocks.f_50106_);
        BlockFamilyInit.setRoot("conquest:green_wool_slab", Blocks.f_50107_);
        BlockFamilyInit.setRoot("conquest:red_wool_slab", Blocks.f_50108_);
        BlockFamilyInit.setRoot("conquest:black_wool_slab", Blocks.f_50109_);
        BlockFamilyInit.setRoot("conquest:large_mirror_2", Blocks.f_50090_);
        BlockFamilyInit.setRoot("conquest:red_mudstone_slab", Blocks.f_50301_);
        BlockFamilyInit.setRoot("conquest:limestone_arrowslit", Blocks.f_50069_);
        BlockFamilyInit.setRoot("conquest:brown_mudstone_slab", Blocks.f_50299_);
        BlockFamilyInit.setRoot("conquest:yellow_mudstone_slab", Blocks.f_50291_);
        BlockFamilyInit.setRoot("conquest:light_limestone_arrowslit", Blocks.f_50228_);
        BlockFamilyInit.setRoot("conquest:gray_cave_silt_slab", Blocks.f_50294_);
        BlockFamilyInit.setRoot("conquest:umbre_mudstone_slab", Blocks.f_50352_);
        BlockFamilyInit.setRoot("conquest:prismarine_slab", Blocks.f_50377_, Blocks.f_50605_);
        BlockFamilyInit.setRoot("conquest:andesite_arrowslit", Blocks.f_50334_);
        BlockFamilyInit.setRoot("conquest:red_mudstone_slab", Blocks.f_50301_);
        BlockFamilyInit.setRoot("conquest:black_hardened_clay_slab", Blocks.f_50302_);
        BlockFamilyInit.setRoot("conquest:magma_slab", Blocks.f_50450_);
        BlockFamilyInit.setRoot("conquest:orange_mudstone_slab", Blocks.f_50288_);
        BlockFamilyInit.setRoot("conquest:granite_arrowslit", Blocks.f_50122_);
        BlockFamilyInit.setRoot("conquest:peridotite_slab", Blocks.f_50752_);
        BlockFamilyInit.setRoot("conquest:end_stone_slab", Blocks.f_50259_);
        BlockFamilyInit.setRoot("conquest:light_mudstone_slab", Blocks.f_50287_);
        BlockFamilyInit.setRoot("conquest:obsidian_slab", Blocks.f_50080_);
        BlockFamilyInit.setRoot("conquest:stack_of_coal_layer", Blocks.f_50353_);
        BlockFamilyInit.setRoot("conquest:grass_block_layer", Blocks.f_50440_);
        BlockFamilyInit.setRoot("conquest:gray_clay_slab", Blocks.f_50129_);
        BlockFamilyInit.setRoot("conquest:dark_mud_slab", Blocks.f_220864_);
        BlockFamilyInit.setRoot("conquest:packed_mud_slab", Blocks.f_220843_);
        BlockFamilyInit.setRoot("conquest:loamy_dirt_slab", Blocks.f_50493_);
        BlockFamilyInit.setRoot("conquest:vibrant_autumnal_forest_floor_layer", Blocks.f_50599_);
        BlockFamilyInit.setRoot("conquest:mycelium_layer", Blocks.f_50195_);
        BlockFamilyInit.setRoot("conquest:dirt_path_layer", Blocks.f_50546_);
        BlockFamilyInit.setRoot("conquest:netherrack_layer", Blocks.f_50134_);
        BlockFamilyInit.setRoot("conquest:soul_sand_layer", Blocks.f_50135_);
        BlockFamilyInit.setRoot("conquest:gravel_layer", Blocks.f_49994_);
        BlockFamilyInit.setRoot("conquest:red_sand_layer", Blocks.f_49993_);
        BlockFamilyInit.setRoot("conquest:sand_layer", Blocks.f_49992_);
        BlockFamilyInit.setRoot("conquest:snow_slab", Blocks.f_50127_, Blocks.f_50125_);
        BlockFamilyInit.setRoot("conquest:palm_log_large_branch", Blocks.f_50002_, Blocks.f_50014_);
        BlockFamilyInit.setRoot("conquest:acacia_log_large_branch", Blocks.f_50003_, Blocks.f_50015_);
        BlockFamilyInit.setRoot("conquest:oak_log_large_branch", Blocks.f_49999_, Blocks.f_50011_);
        BlockFamilyInit.setRoot("conquest:dark_oak_log_large_branch", Blocks.f_50004_, Blocks.f_50043_);
        BlockFamilyInit.setRoot("conquest:birch_log_large_branch", Blocks.f_50001_, Blocks.f_50013_);
        BlockFamilyInit.setRoot("conquest:dark_spruce_log_large_branch", Blocks.f_50000_, Blocks.f_50012_);
        BlockFamilyInit.setRoot("conquest:ancient_debris_layer", Blocks.f_50722_);
        BlockFamilyInit.setRoot("conquest:soul_soil_layer", Blocks.f_50136_);
        BlockFamilyInit.setRoot("conquest:crimson_nylium_layer", Blocks.f_50699_);
        BlockFamilyInit.setRoot("conquest:warped_nylium_layer", Blocks.f_50690_);
        BlockFamilyInit.setRoot("conquest:nether_wart_block_layer", Blocks.f_50451_);
        BlockFamilyInit.setRoot("conquest:warped_wart_block_layer", Blocks.f_50692_);
        BlockFamilyInit.setRoot("conquest:blackstone_slab", Blocks.f_50730_, Blocks.f_50731_, Blocks.f_50732_);
        BlockFamilyInit.setRoot("conquest:gilded_blackstone_slab", Blocks.f_50706_);
        BlockFamilyInit.setRoot("conquest:crying_obsidian_slab", Blocks.f_50723_);
        BlockFamilyInit.setRoot("conquest:large_marble_blocks_small_arch", Blocks.f_50714_);
        BlockFamilyInit.setRoot("conquest:polished_basalt_vertical_slab", Blocks.f_50138_);
        BlockFamilyInit.setRoot("conquest:large_smooth_limestone_brick_small_arch", Blocks.f_50470_);
        BlockFamilyInit.setRoot("conquest:crimson_stem_vertical_slab", Blocks.f_50695_, Blocks.f_50697_);
        BlockFamilyInit.setRoot("conquest:stripped_crimson_stem_vertical_slab", Blocks.f_50696_, Blocks.f_50698_);
        BlockFamilyInit.setRoot("conquest:warped_stem_vertical_slab", Blocks.f_50686_, Blocks.f_50688_);
        BlockFamilyInit.setRoot("conquest:stripped_warped_stem_vertical_slab", Blocks.f_50687_, Blocks.f_50689_);
        BlockFamilyInit.setRoot("conquest:basalt_arrowslit", Blocks.f_50137_);
        BlockFamilyInit.setRoot("conquest:crimson_shell_planks_slab", Blocks.f_50655_, Blocks.f_50671_, Blocks.f_50661_, Blocks.f_50665_, Blocks.f_50659_, Blocks.f_50669_, Blocks.f_50673_, Blocks.f_50667_, Blocks.f_50663_);
        BlockFamilyInit.setRoot("conquest:warped_planks_slab", Blocks.f_50656_, Blocks.f_50672_, Blocks.f_50662_, Blocks.f_50666_, Blocks.f_50660_, Blocks.f_50670_, Blocks.f_50674_, Blocks.f_50668_, Blocks.f_50664_);
        BlockFamilyInit.setRoot("conquest:chiseled_polished_blackstone_slab", Blocks.f_50737_);
        BlockFamilyInit.setRoot("conquest:polished_blackstone_small_arch", Blocks.f_50734_, Blocks.f_50707_, Blocks.f_50711_, Blocks.f_50710_);
        BlockFamilyInit.setRoot("conquest:polished_blackstone_bricks_small_arch", Blocks.f_50735_, Blocks.f_50739_, Blocks.f_50740_);
        BlockFamilyInit.setRoot("conquest:cracked_polished_blackstone_bricks_small_arch", Blocks.f_50736_);
        BlockFamilyInit.setRoot("conquest:old_rusted_metal_panel_arrowslit", Blocks.f_50712_);
        BlockFamilyInit.setRoot("conquest:cracked_old_rusted_metal_arrowslit", Blocks.f_50713_);
        BlockFamilyInit.setRoot("conquest:gold_block_vertical_slab", Blocks.f_50074_);
        BlockFamilyInit.add("conquest:old_iron_block", Blocks.f_50153_);
        BlockFamilyInit.setRoot("conquest:cut_copper_slab", Blocks.f_152578_, Blocks.f_152582_);
        BlockFamilyInit.setRoot("conquest:exposed_cut_copper_slab", Blocks.f_152577_, Blocks.f_152581_);
        BlockFamilyInit.setRoot("conquest:weathered_cut_copper_slab", Blocks.f_152576_, Blocks.f_152580_);
        BlockFamilyInit.setRoot("conquest:oxidized_cut_copper_slab", Blocks.f_152575_, Blocks.f_152579_);
        BlockFamilyInit.setRoot("conquest:raw_copper_slab", Blocks.f_152599_);
        BlockFamilyInit.setRoot("conquest:raw_gold_slab", Blocks.f_152600_);
        BlockFamilyInit.setRoot("conquest:raw_iron_slab", Blocks.f_152598_);
        BlockFamilyInit.setRoot("conquest:calcite_and_limestone_slab", Blocks.f_152497_);
        BlockFamilyInit.setRoot("conquest:copper_balustrade", Blocks.f_152571_);
        BlockFamilyInit.setRoot("conquest:exposed_copper_balustrade", Blocks.f_152573_);
        BlockFamilyInit.setRoot("conquest:weathered_copper_balustrade", Blocks.f_152572_);
        BlockFamilyInit.setRoot("conquest:oxidized_copper_balustrade", Blocks.f_152574_);
        BlockFamilyInit.setRoot("conquest:polished_deepslate_small_arch", Blocks.f_152555_, Blocks.f_152556_, Blocks.f_152558_);
        BlockFamilyInit.setRoot("conquest:deepslate_tile_slab", Blocks.f_152559_, Blocks.f_152560_, Blocks.f_152562_);
        BlockFamilyInit.setRoot("conquest:cracked_deepslate_tile_slab", Blocks.f_152595_);
        BlockFamilyInit.setRoot("conquest:chiseled_deepslate_slab", Blocks.f_152593_);
        BlockFamilyInit.setRoot("conquest:pumice_slab", Blocks.f_152597_);
        BlockFamilyInit.setRoot("conquest:ice_slab", Blocks.f_50126_);
        BlockFamilyInit.setRoot("conquest:packed_ice_slab", Blocks.f_50354_);
        BlockFamilyInit.setRoot("conquest:blue_ice_slab", Blocks.f_50568_);
        BlockFamilyInit.setRoot("conquest:bubble_coral_block_slab", Blocks.f_50586_);
        BlockFamilyInit.setRoot("conquest:horn_coral_block_slab", Blocks.f_50588_);
        BlockFamilyInit.setRoot("conquest:fire_coral_block_slab", Blocks.f_50587_);
        BlockFamilyInit.setRoot("conquest:tube_coral_block_slab", Blocks.f_50584_);
        BlockFamilyInit.setRoot("conquest:brain_coral_block_slab", Blocks.f_50585_);
        BlockFamilyInit.setRoot("conquest:dead_bubble_coral_block_slab", Blocks.f_50581_);
        BlockFamilyInit.setRoot("conquest:dead_horn_coral_block_slab", Blocks.f_50583_);
        BlockFamilyInit.setRoot("conquest:dead_fire_coral_block_slab", Blocks.f_50582_);
        BlockFamilyInit.setRoot("conquest:dead_tube_coral_block_slab", Blocks.f_50579_);
        BlockFamilyInit.setRoot("conquest:dead_brain_coral_block_slab", Blocks.f_50580_);
        BlockFamilyInit.setRoot("conquest:red_mushroom_block_slab", Blocks.f_50181_);
        BlockFamilyInit.setRoot("conquest:brown_mushroom_block_slab", Blocks.f_50180_);
        BlockFamilyInit.setRoot("conquest:mushroom_stem_slab", Blocks.f_50182_);
        BlockFamilyInit.addCarpets();
        BlockFamilyInit.addStoneShapes();
    }

    private static void addCarpets() {
        BlockFamilyInit.add("conquest:white_carpet", Blocks.f_50336_);
        BlockFamilyInit.add("conquest:orange_carpet", Blocks.f_50337_);
        BlockFamilyInit.add("conquest:magenta_carpet", Blocks.f_50338_);
        BlockFamilyInit.add("conquest:light_blue_carpet", Blocks.f_50339_);
        BlockFamilyInit.add("conquest:yellow_carpet", Blocks.f_50340_);
        BlockFamilyInit.add("conquest:lime_carpet", Blocks.f_50341_);
        BlockFamilyInit.add("conquest:pink_carpet", Blocks.f_50342_);
        BlockFamilyInit.add("conquest:gray_carpet", Blocks.f_50343_);
        BlockFamilyInit.add("conquest:light_gray_carpet", Blocks.f_50344_);
        BlockFamilyInit.add("conquest:cyan_carpet", Blocks.f_50345_);
        BlockFamilyInit.add("conquest:purple_carpet", Blocks.f_50346_);
        BlockFamilyInit.add("conquest:blue_carpet", Blocks.f_50347_);
        BlockFamilyInit.add("conquest:brown_carpet", Blocks.f_50348_);
        BlockFamilyInit.add("conquest:green_carpet", Blocks.f_50349_);
        BlockFamilyInit.add("conquest:red_carpet", Blocks.f_50350_);
        BlockFamilyInit.add("conquest:black_carpet", Blocks.f_50351_);
    }

    private static void addStoneShapes() {
        BlockFamilyInit.add(Blocks.f_50069_, Blocks.f_50404_, Blocks.f_50635_);
        BlockFamilyInit.add(Blocks.f_50334_, Blocks.f_50600_, Blocks.f_50639_, Blocks.f_50611_);
        BlockFamilyInit.add(Blocks.f_50228_, Blocks.f_50603_, Blocks.f_50642_, Blocks.f_50615_);
        BlockFamilyInit.add(Blocks.f_50122_, Blocks.f_50651_, Blocks.f_50638_, Blocks.f_50608_);
        BlockFamilyInit.add(Blocks.f_50387_, Blocks.f_50602_, Blocks.f_50641_);
        BlockFamilyInit.add(Blocks.f_50281_, Blocks.f_50646_, Blocks.f_50632_);
        BlockFamilyInit.add(Blocks.f_50175_, Blocks.f_50643_, Blocks.f_50629_);
    }

    private static void setRoot(String target, Block block) {
        Family<Block> family = FamilyRegistry.BLOCKS.getFamily(new ResourceLocation(target));
        family.setRoot(block);
        FamilyRegistry.BLOCKS.register(block, family);
    }

    private static void setRoot(String parent, Block root, Block ... blocks) {
        Family<Block> family = FamilyRegistry.BLOCKS.getFamily(new ResourceLocation(parent));
        family.setRoot(root);
        FamilyRegistry.BLOCKS.register(root, family);
        for (Block block : blocks) {
            family.add(block);
            FamilyRegistry.BLOCKS.register(block, family);
        }
    }

    private static void add(Block parent, Block ... blocks) {
        Family<Block> family = FamilyRegistry.BLOCKS.getFamily(parent);
        for (Block block : blocks) {
            family.add(block);
            FamilyRegistry.BLOCKS.register(block, family);
        }
    }

    private static void add(String parent, Block ... blocks) {
        Family<Block> family = FamilyRegistry.BLOCKS.getFamily(new ResourceLocation(parent));
        for (Block block : blocks) {
            family.add(block);
            FamilyRegistry.BLOCKS.register(block, family);
        }
    }

    public static void loadBlockFamilies(ResourceManager resourceManager) {
        Map resources = resourceManager.m_214159_("families", id -> id.m_135815_().endsWith(".json"));
        resources.forEach((identifier, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.m_215507_());){
                BlockFamilyJson familyJson = (BlockFamilyJson)GSON.fromJson((Reader)reader, BlockFamilyJson.class);
                Block parent = BlockFamilyInit.getBlockFromIdentifier(familyJson.parentBlock);
                if (parent == null) {
                    System.err.println("Failed to find parent block: " + familyJson.parentBlock);
                    return;
                }
                BlockFamily family = new BlockFamily((CreativeModeTab)ModGroups.UTILITY, TypeList.EMPTY);
                family.add(parent);
                FamilyRegistry.BLOCKS.register(parent, family);
                for (String blockId : familyJson.familyBlocks) {
                    Block block = BlockFamilyInit.getBlockFromIdentifier(blockId);
                    if (block == null) continue;
                    family.add(block);
                    FamilyRegistry.BLOCKS.register(block, family);
                }
            }
            catch (Exception e) {
                System.err.println("Error processing block family file: " + String.valueOf(identifier));
                e.printStackTrace();
            }
        });
    }

    private static Block getBlockFromIdentifier(String identifier) {
        try {
            ResourceLocation blockId = new ResourceLocation(identifier);
            return (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
        }
        catch (Exception e) {
            System.err.println("Invalid block identifier: " + identifier);
            return null;
        }
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)BlockFamilyInit::loadBlockFamilies));
    }

    private static class BlockFamilyJson {
        @SerializedName(value="parent_block")
        private String parentBlock;
        @SerializedName(value="family_blocks")
        private List<String> familyBlocks;

        private BlockFamilyJson() {
        }
    }
}

