/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.entities.painting.render;

import com.conquestreforged.content.entities.painting.EntityPainting;
import com.conquestreforged.content.entities.painting.art.ArtType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PaintingRenderer
extends EntityRenderer<EntityPainting> {
    public PaintingRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(EntityPainting painting, float yaw, float ticks, PoseStack matrix, MultiBufferSource buffer, int light) {
        matrix.m_85836_();
        matrix.m_252781_(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), 180.0f - yaw));
        matrix.m_85841_(0.0625f, 0.0625f, 0.0625f);
        ArtType art = painting.getArt();
        ResourceLocation texture = this.getTexture(painting);
        RenderType renderType = RenderType.m_110452_((ResourceLocation)texture);
        VertexConsumer builder = buffer.m_6299_(renderType);
        this.render(matrix, builder, painting, art.sizeX, art.sizeY, art.offsetX, art.offsetY);
        matrix.m_85849_();
        super.m_7392_((Entity)painting, yaw, ticks, matrix, buffer, light);
    }

    public ResourceLocation getTexture(EntityPainting entity) {
        return entity.getPaintingType().getRegistryName();
    }

    private void render(PoseStack matrix, VertexConsumer builder, EntityPainting entity, int width, int height, int textureU, int textureV) {
        PoseStack.Pose entry = matrix.m_85850_();
        Matrix4f position = entry.m_252922_();
        Matrix3f normals = entry.m_252943_();
        float xCenter = (float)(-width) / 2.0f;
        float yCenter = (float)(-height) / 2.0f;
        for (int x = 0; x < width / 16; ++x) {
            for (int y = 0; y < height / 16; ++y) {
                float minX = xCenter + (float)(x * 16);
                float minY = yCenter + (float)(y * 16);
                float maxX = xCenter + (float)((x + 1) * 16);
                float maxY = yCenter + (float)((y + 1) * 16);
                int lightX = Mth.m_14107_((double)entity.m_20185_());
                int lightY = Mth.m_14107_((double)(entity.m_20186_() + (double)((maxY + minY) / 2.0f / 16.0f)));
                int lightZ = Mth.m_14107_((double)entity.m_20189_());
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)new BlockPos(lightX, lightY, lightZ));
                float txMin = (float)(textureU + width - x * 16) / 256.0f;
                float txMax = (float)(textureU + width - (x + 1) * 16) / 256.0f;
                float tyMin = (float)(textureV + height - y * 16) / 256.0f;
                float tyMax = (float)(textureV + height - (y + 1) * 16) / 256.0f;
                this.vertex(position, normals, builder, maxX, minY, txMax, tyMin, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, minY, txMin, tyMin, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, maxY, txMin, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, maxX, maxY, txMax, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, maxX, maxY, txMax, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, maxY, txMin, tyMax, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, minX, minY, txMin, tyMin, 0.2f, 0, 0, -1, light);
                this.vertex(position, normals, builder, maxX, minY, txMax, tyMin, 0.2f, 0, 0, -1, light);
            }
        }
    }

    private void vertex(Matrix4f position, Matrix3f normals, VertexConsumer builder, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        builder.m_252986_(position, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normals, (float)nx, (float)ny, (float)nz).m_5752_();
    }
}

