/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.block;

import com.conquestreforged.core.block.factory.InitializationException;
import com.conquestreforged.core.item.ItemUtils;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class StateUtils {
    public static Optional<BlockState> getOrDefault(ItemStack stack) {
        return StateUtils.toItemBlock(stack.m_41720_()).map(item -> StateUtils.fromStack(stack, item).orElse(item.m_40614_().m_49966_()));
    }

    public static Optional<BlockState> fromStack(ItemStack stack) {
        return StateUtils.toItemBlock(stack.m_41720_()).flatMap(item -> StateUtils.fromStack(stack, item));
    }

    public static Optional<BlockState> fromStack(ItemStack stack, BlockItem item) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag == null) {
            return Optional.of(item.m_40614_().m_49966_());
        }
        CompoundTag stateTag = stackTag.m_128469_("BlockStateTag");
        if (stateTag.m_128456_()) {
            return Optional.of(item.m_40614_().m_49966_());
        }
        BlockState state = item.m_40614_().m_49966_();
        StateDefinition container = item.m_40614_().m_49965_();
        for (String key : stateTag.m_128431_()) {
            Property property = container.m_61081_(key);
            if (property == null) continue;
            String s1 = stateTag.m_128423_(key).m_7916_();
            state = StateUtils.with(state, property, s1);
        }
        if (state == item.m_40614_().m_49966_()) {
            return Optional.empty();
        }
        return Optional.of(state);
    }

    public static Optional<BlockItem> toItemBlock(Item item) {
        return ItemUtils.toItem(item, BlockItem.class);
    }

    public static BlockState parse(String input) {
        int valStart;
        int valEnd;
        int keyStart;
        int keyEnd;
        int nameEnd;
        String name;
        int domainEnd = input.indexOf(58);
        String domain = domainEnd == -1 ? "minecraft" : input.substring(0, domainEnd);
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(domain, name = (nameEnd = input.indexOf(91)) == -1 ? input.substring(domainEnd + 1) : input.substring(domainEnd + 1, nameEnd)));
        if (block == null) {
            throw new InitializationException("invalid block " + input);
        }
        BlockState state = block.m_49966_();
        for (int i = nameEnd + 1; i < input.length() && (keyEnd = StateUtils.indexOf(input, keyStart = i, '=')) != -1 && (valEnd = StateUtils.indexOf(input, valStart = keyEnd + 1, ',', ']')) != -1; ++i) {
            String key = input.substring(keyStart, keyEnd);
            String value = input.substring(valStart, valEnd);
            state = StateUtils.with(state, key, value);
            i = valEnd + 1;
        }
        return state;
    }

    private static int indexOf(String string, int from, char ... chars) {
        for (char c : chars) {
            int i = string.indexOf(c, from);
            if (i == -1) continue;
            return i;
        }
        return -1;
    }

    private static BlockState with(BlockState state, String key, String value) {
        Property property = state.m_60734_().m_49965_().m_61081_(key);
        if (property == null) {
            return state;
        }
        return StateUtils.with(state, property, value);
    }

    public static <T extends Comparable<T>> BlockState with(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }
}

