/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.block.factory;

import com.conquestreforged.core.block.builder.BlockName;
import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.block.data.BlockData;
import com.conquestreforged.core.block.data.BlockDataRegistry;
import com.conquestreforged.core.block.data.BlockTemplate;
import com.conquestreforged.core.block.data.BlockTemplateCache;
import com.conquestreforged.core.block.factory.BlockType;
import com.conquestreforged.core.block.factory.BlockTypeCache;
import com.conquestreforged.core.block.factory.TypeList;
import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyRegistry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public interface BlockFactory {
    public Props getProps();

    public BlockName getName();

    public BlockState getParent();

    public Family<Block> createFamily(TypeList var1);

    default public void register(TypeList types) {
        Family<Block> family = this.createFamily(types);
        for (Class<? extends Block> type : types) {
            BlockType blockType = (BlockType)BlockTypeCache.getInstance().get(type);
            BlockTemplate template = (BlockTemplate)BlockTemplateCache.getInstance().get(type);
            BlockName name = this.getName();
            Props props = this.getProps().template(template);
            Block block = blockType.create(props);
            BlockData data = new BlockData(block, template, name, props);
            ForgeRegistries.ITEMS.register(data.getRegistryName(), (Object)data.getItem());
            BlockDataRegistry.getInstance().register(data);
            if (!this.getProps().hasParent()) {
                this.getProps().parent(data.getBlock().m_49966_());
            }
            family.add(data.getBlock());
        }
        FamilyRegistry.BLOCKS.register(family);
    }
}

