/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.family;

import com.conquestreforged.core.block.factory.TypeList;
import com.conquestreforged.core.item.family.DeferredFamily;
import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyFactory;
import com.conquestreforged.core.item.family.FamilyRegistry;
import com.conquestreforged.core.util.cache.Cache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DeferredFamilyRegistry<T extends ItemLike>
extends Cache<ResourceLocation, DeferredFamily<T>>
implements FamilyFactory<T> {
    public static final DeferredFamilyRegistry<Block> BLOCKS = new DeferredFamilyRegistry<Block>(Blocks.f_50016_, FamilyRegistry.BLOCKS);
    private final T empty;
    private final DeferredFamily<T> none;
    private final FamilyRegistry<T> registry;

    private DeferredFamilyRegistry(T empty, FamilyRegistry<T> registry) {
        this.empty = empty;
        this.registry = registry;
        this.none = new DeferredFamily<T>(null, empty, registry);
    }

    @Override
    public DeferredFamily<T> compute(ResourceLocation name) {
        return new DeferredFamily<T>(name, this.empty, this.registry);
    }

    @Override
    public Family<T> create(ResourceLocation name, CreativeModeTab group, TypeList types) {
        if (name == null) {
            return this.none;
        }
        return (Family)this.get(name);
    }

    public void registerAll() {
        this.forEach((name, family) -> family.register());
    }
}

