/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.family;

import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.block.BlockFamily;
import com.conquestreforged.core.item.family.item.ItemFamily;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class FamilyRegistry<T extends ItemLike> {
    public static final FamilyRegistry<Block> BLOCKS = new FamilyRegistry<Block>(BlockFamily.EMPTY);
    public static final FamilyRegistry<Item> ITEMS = new FamilyRegistry<Item>(ItemFamily.EMPTY);
    private final Family<T> empty;
    private final Map<ResourceLocation, Family<T>> families = new HashMap<ResourceLocation, Family<T>>();

    public FamilyRegistry(Family<T> empty) {
        this.empty = empty;
    }

    public void register(Family<T> family) {
        for (ItemLike member : family.getMembers()) {
            this.register(member, family);
        }
    }

    public void register(T member, Family<T> family) {
        if (family.isAbsent()) {
            return;
        }
        this.families.put(BuiltInRegistries.f_257033_.m_7981_((Object)member.m_5456_()), family);
    }

    public void registerToFamily(ResourceLocation parent, T child) {
        Family<T> family = this.getFamily(parent);
        if (family.isPresent()) {
            family.add(child);
        }
    }

    public Family<T> getFamily(T member) {
        return this.getFamily(BuiltInRegistries.f_257033_.m_7981_((Object)member.m_5456_()));
    }

    public Family<T> getFamily(ResourceLocation name) {
        return this.families.getOrDefault(name, this.empty);
    }

    public Stream<Family<T>> values() {
        return this.families.values().stream().distinct();
    }

    public static void bake() {
        BLOCKS.values().forEach(Family::trim);
        ITEMS.values().forEach(Family::trim);
    }
}

