/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.group.sort;

import com.conquestreforged.core.item.group.sort.Sorter;
import com.conquestreforged.core.util.Provider;
import java.io.BufferedReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemList
implements Sorter<ItemStack>,
Comparator<ItemStack> {
    private final Map<String, Entry> index;

    private ItemList(Map<String, Entry> index) {
        this.index = index;
    }

    @Override
    public int compare(ItemStack o1, ItemStack o2) {
        int i1 = ItemList.getIndex(o1, this.index);
        int i2 = ItemList.getIndex(o2, this.index);
        return Integer.compare(i1, i2);
    }

    @Override
    public void apply(NonNullList<ItemStack> items) {
        this.fill(items);
    }

    @Override
    public void sort(NonNullList<ItemStack> items) {
        items.sort((Comparator)this);
    }

    private void fill(NonNullList<ItemStack> items) {
        for (Map.Entry<String, Entry> e : this.index.entrySet()) {
            if (ItemList.contains(items, e.getKey())) continue;
            int size = items.size();
            Item item = e.getValue().stack.get();
            if (items.size() != size) continue;
            items.add((Object)new ItemStack((ItemLike)item));
        }
    }

    private static int getIndex(ItemStack stack, Map<String, Entry> index) {
        String name = String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        Entry entry = index.get(name);
        if (entry == null) {
            return index.size();
        }
        return entry.index;
    }

    private static boolean contains(List<ItemStack> items, String find) {
        for (ItemStack stack : items) {
            if (!String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_())).equals(find)) continue;
            return true;
        }
        return false;
    }

    public static ItemList read(BufferedReader reader) {
        AtomicInteger order = new AtomicInteger(0);
        HashMap<String, Entry> index = new HashMap<String, Entry>(50);
        reader.lines().forEach(item -> {
            if (item.isEmpty()) {
                return;
            }
            index.put((String)item, new Entry(order.get(), Provider.item(item)));
            order.addAndGet(1);
        });
        return new ItemList(index);
    }

    private static class Entry {
        private final int index;
        private final Provider<Item> stack;

        private Entry(int index, Provider<Item> provider) {
            this.index = index;
            this.stack = provider;
        }
    }
}

