/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.mixin;

import com.conquestreforged.content.effects.CustomSlownessEffect;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractClientPlayer.class}, priority=500)
public abstract class AbstractClientPlayerEntityMixin {
    @ModifyReturnValue(method={"getFovMultiplier"}, at={@At(value="RETURN")})
    private float adjustFovWithCustomEffect(float original) {
        AbstractClientPlayer player = (AbstractClientPlayer)this;
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null && speedAttribute.m_22111_(CustomSlownessEffect.MODIFIER_ID) != null) {
            return this.calculateAdjustedFov(player, speedAttribute);
        }
        return original;
    }

    private float calculateAdjustedFov(AbstractClientPlayer player, AttributeInstance speedAttribute) {
        double baseValue;
        Set modifiers = speedAttribute.m_22122_();
        double valueWithoutOurModifier = baseValue = speedAttribute.m_22115_();
        for (AttributeModifier modifier : modifiers) {
            if (modifier.m_22209_().equals(CustomSlownessEffect.MODIFIER_ID)) continue;
            if (modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                valueWithoutOurModifier += modifier.m_22218_();
                continue;
            }
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            valueWithoutOurModifier += baseValue * modifier.m_22218_();
        }
        double multiplierTotal = 1.0;
        for (AttributeModifier modifier : modifiers) {
            if (modifier.m_22209_().equals(CustomSlownessEffect.MODIFIER_ID) || modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            multiplierTotal += modifier.m_22218_();
        }
        valueWithoutOurModifier *= multiplierTotal;
        float f = 1.0f;
        if (player.m_150110_().f_35935_) {
            f *= 1.1f;
        }
        if (player.m_150110_().m_35947_() == 0.0f || Float.isNaN(f *= ((float)valueWithoutOurModifier / player.m_150110_().m_35947_() + 1.0f) / 2.0f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        if (player.m_6117_()) {
            if (player.m_21211_().m_150930_(Items.f_42411_)) {
                int i = player.m_21252_();
                float g = (float)i / 20.0f;
                g = g > 1.0f ? 1.0f : (g *= g);
                f *= 1.0f - g * 0.15f;
            } else if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && player.m_150108_()) {
                return 0.1f;
            }
        }
        return Mth.m_14179_((float)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).floatValue(), (float)1.0f, (float)f);
    }
}

