/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette;

import com.conquestreforged.client.gui.AbstractContainer;
import com.conquestreforged.client.gui.Hotbar;
import com.conquestreforged.client.gui.palette.component.PaletteSettings;
import com.conquestreforged.client.gui.palette.component.PaletteSlot;
import com.conquestreforged.client.gui.palette.component.Style;
import com.conquestreforged.client.gui.palette.shape.Bounds;
import com.conquestreforged.client.gui.palette.shape.FloatMath;
import com.conquestreforged.client.gui.palette.shape.Point;
import com.conquestreforged.client.gui.palette.shape.Polygon;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PaletteContainer
extends AbstractContainer {
    public static final MenuType<PaletteContainer> TYPE = new MenuType(PaletteContainer::new, FeatureFlagSet.m_246902_());
    private static final ResourceLocation BACKGROUND = new ResourceLocation("conquest:textures/gui/picker/slot.png");
    public static final int RADIUS = 65;
    private static final int EDGES = 6;
    private static final int PADDING = 40;
    private static final int ANGLE_OFFSET = -90;
    private final int radialCount;
    private final Style centerStyle;
    private final Style radialStyle;
    private final Style draggedStyle;
    private final Container paletteInventory;
    private final Hotbar hotbar;

    private PaletteContainer(int id, Container inventory) {
        super(TYPE, id);
        this.radialCount = 0;
        this.hotbar = new Hotbar(inventory);
        this.paletteInventory = inventory;
        this.centerStyle = Style.center(BACKGROUND);
        this.draggedStyle = Style.center(BACKGROUND);
        this.radialStyle = Style.radial(0, BACKGROUND);
    }

    public PaletteContainer(Container inventory, Container palette) {
        super(TYPE, 0);
        this.radialCount = palette.m_6643_() - 1;
        this.hotbar = new Hotbar(inventory);
        this.paletteInventory = palette;
        this.centerStyle = Style.center(BACKGROUND);
        this.draggedStyle = Style.center(BACKGROUND);
        this.radialStyle = Style.radial(this.radialCount, BACKGROUND);
    }

    public void updateStyle(PaletteSettings settings) {
        this.draggedStyle.highlightScale = settings.highlightScale;
        this.draggedStyle.highlightColor = settings.highlightColor;
        this.draggedStyle.highlightColor = settings.selectedColor;
        this.radialStyle.highlightScale = settings.highlightScale;
        this.radialStyle.highlightColor = settings.highlightColor;
        this.radialStyle.hoveredColor = settings.hoveredColor;
        this.centerStyle.highlightScale = settings.highlightScale;
        this.centerStyle.highlightColor = settings.highlightColor;
        this.centerStyle.hoveredColor = settings.hoveredColor;
    }

    public Style getDraggedStyle() {
        return this.draggedStyle;
    }

    public void init(AbstractContainerScreen<?> screen) {
        int centerX = 109;
        int centerY = 109;
        this.f_38839_.clear();
        this.m_38897_(new PaletteSlot(this.paletteInventory, this.centerStyle, Bounds.NONE, 0, centerX, centerY));
        Polygon polygon = new Polygon(6, 65, 40, 40);
        polygon.init(centerX, centerY);
        float spacing = 360.0f / (float)this.radialCount;
        float halfSpacing = spacing / 2.0f;
        for (int slotIndex = 1; slotIndex < this.paletteInventory.m_6643_(); ++slotIndex) {
            int posIndex = slotIndex - 1;
            float angle = FloatMath.clampAngle((float)posIndex * spacing + -90.0f);
            Point pos = polygon.getPosition(angle);
            Bounds bounds = polygon.getBounds(angle, halfSpacing);
            this.m_38897_(new PaletteSlot(this.paletteInventory, this.radialStyle, bounds, slotIndex, pos.x, pos.y));
            if (slotIndex < this.paletteInventory.m_6643_()) continue;
            throw new UnsupportedOperationException();
        }
        int screenBottom = screen.f_96544_ - screen.f_97736_;
        int top = screenBottom - this.hotbar.getHeight();
        this.hotbar.addTo(this, centerX, top);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot;
        if (index >= this.f_38839_.size() - 9 && index < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(index)) != null && slot.m_6657_()) {
            slot.m_269060_(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5622_(Slot slot) {
        return slot.f_40218_ != this.paletteInventory;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.paletteInventory;
    }

    public boolean m_6875_(Player player) {
        return player.m_7500_();
    }

    public Hotbar getHotbar() {
        return this.hotbar;
    }

    public Container getPaletteInventory() {
        return this.paletteInventory;
    }

    public void visitHotbar(Consumer<Slot> consumer) {
        for (int i = this.f_38839_.size() - 9; i < this.f_38839_.size(); ++i) {
            consumer.accept(this.m_38853_(i));
        }
    }

    public void visitCenter(Consumer<PaletteSlot> consumer) {
        PaletteSlot slot = (PaletteSlot)this.m_38853_(0);
        consumer.accept(slot);
    }

    public void visitRadius(int mouseX, int mouseY, BiConsumer<PaletteSlot, Float> consumer) {
        Slot closest = this.getClosestSlot(mouseX, mouseY, false);
        if (closest == null) {
            return;
        }
        int index = closest.f_40219_ - 1;
        this.visitRadialSlot(index, 0, consumer);
        int i = 1;
        for (int visited = 0; visited < this.radialCount && visited + 1 < this.radialCount; visited += 2) {
            this.visitRadialSlot(index - i, i, consumer);
            if (visited + 2 >= this.radialCount) break;
            this.visitRadialSlot(index + i, i, consumer);
            ++i;
        }
    }

    private void visitRadialSlot(int index, int relativeIndex, BiConsumer<PaletteSlot, Float> consumer) {
        int slotIndex = this.wrapSlotIndex(index);
        float depth = this.getRelativeDepth(relativeIndex);
        PaletteSlot slot = (PaletteSlot)this.m_38853_(slotIndex + 1);
        consumer.accept(slot, Float.valueOf(depth));
    }

    private int wrapSlotIndex(int index) {
        if (index < 0) {
            return this.radialCount + index;
        }
        if (index >= this.radialCount) {
            return index - this.radialCount;
        }
        return index;
    }

    private float getRelativeDepth(float i) {
        if (i == 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Nullable
    public Slot getClosestSlot(int mouseX, int mouseY, boolean all) {
        Slot nearest = null;
        int dist2 = Integer.MAX_VALUE;
        for (Slot slot : this.f_38839_) {
            if (!all && (slot.m_150661_() == 0 || slot.f_40218_ != this.paletteInventory)) continue;
            int dx = slot.f_40220_ + 8 - mouseX;
            int dy = slot.f_40221_ + 8 - mouseY;
            int d2 = dx * dx + dy * dy;
            if (nearest != null && d2 >= dist2) continue;
            nearest = slot;
            dist2 = d2;
        }
        return nearest;
    }
}

