/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette.component;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ColorPicker
extends Button {
    private static final int pickerWidth = 128;
    private static final int pickerHeight = 32;
    private static final int sliderWidth = 128;
    private static final int sliderHeight = 10;
    private static final int padding = 1;
    private static final int titleHeight = 10;
    private static final int lineColor = -1711276033;
    private static final float hueOffset = 0.68f;
    private float hue = 0.0f;
    private float saturation = 0.5f;
    private float brightness = 1.0f;
    private boolean dirty = true;
    private final String title;
    private final Consumer<Integer> consumer;
    private final DynamicTexture picker = new DynamicTexture(new NativeImage(128, 32, false));
    private final DynamicTexture slider = new DynamicTexture(new NativeImage(128, 10, false));
    private final ResourceLocation PICKER_ID;
    private final ResourceLocation SLIDER_ID;

    public ColorPicker(String title, int initial, Consumer<Integer> consumer) {
        super(0, 0, 128, 53, (Component)Component.m_237115_((String)""), button -> {}, supplier -> null);
        this.title = title;
        this.consumer = consumer;
        float[] hsb = new Color(initial).getColorComponents(new float[3]);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.PICKER_ID = Minecraft.m_91087_().m_91097_().m_118490_("picker", this.picker);
        this.SLIDER_ID = Minecraft.m_91087_().m_91097_().m_118490_("slider", this.slider);
    }

    public void m_88315_(GuiGraphics drawContext, int mx, int my, float ticks) {
        if (this.dirty) {
            this.renderImage();
        }
        int top = this.m_252907_();
        int left = this.m_252754_();
        drawContext.m_280488_(Minecraft.m_91087_().f_91062_, "TEST", top, left, 0xFFFFFF);
        this.picker.m_117966_();
        drawContext.m_280411_(this.PICKER_ID, left, top += 10, 128, 32, 0.0f, 0.0f, 128, 32, 128, 32);
        this.slider.m_117966_();
        drawContext.m_280411_(this.SLIDER_ID, left, top += 33, 128, 10, 0.0f, 0.0f, 128, 10, 128, 10);
    }

    public boolean m_7979_(double x1, double y1, int button, double x2, double y2) {
        if (this.interact(x2, y2)) {
            return true;
        }
        return super.m_7979_(x1, y1, button, x2, y2);
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (this.interact(mx, my - 10.0)) {
            return super.m_6375_(mx, my, button);
        }
        return false;
    }

    public void dispose() {
        this.picker.close();
        this.slider.close();
    }

    private boolean interact(double mx, double my) {
        boolean color = this.click(mx, my, this.m_252754_(), this.m_252907_(), this.picker, (x, y) -> {
            this.hue = x.floatValue();
            this.saturation = y.floatValue();
            this.consumer.accept(ColorPicker.getRGB(this.hue, this.saturation, this.brightness));
            this.dirty = true;
        });
        if (color) {
            return true;
        }
        return this.click(mx, my, this.m_252754_(), this.m_252907_() + 32 + 1, this.slider, (x1, y1) -> {
            this.brightness = x1.floatValue();
            this.consumer.accept(ColorPicker.getRGB(this.hue, this.saturation, this.brightness));
            this.dirty = true;
        });
    }

    private boolean click(double mx, double my, int left, int top, DynamicTexture texture, BiConsumer<Float, Float> consumer) {
        NativeImage image = texture.m_117991_();
        if (image == null) {
            return false;
        }
        if (mx >= (double)left && mx < (double)(left + image.m_84982_()) && my >= (double)top && my < (double)(top + image.m_85084_())) {
            float dx = (int)mx - left;
            float dy = (int)my - top;
            float x = dx / (float)image.m_84982_();
            float y = dy / (float)image.m_85084_();
            consumer.accept(Float.valueOf(x), Float.valueOf(y));
            return true;
        }
        return false;
    }

    private void renderImage() {
        this.renderColor();
        this.renderBrightness();
        this.picker.m_117985_();
        this.slider.m_117985_();
    }

    private void renderColor() {
        NativeImage picker = this.picker.m_117991_();
        if (picker == null) {
            return;
        }
        int crosshairX = (int)((float)picker.m_84982_() * this.hue);
        int crosshairY = (int)((float)picker.m_85084_() * this.saturation);
        float displayBrightness = 0.5f + 0.5f * this.brightness;
        for (int y = 0; y < picker.m_85084_(); ++y) {
            float sat = (float)y / 32.0f;
            for (int x = 0; x < picker.m_84982_(); ++x) {
                float hue = (float)x / 128.0f;
                int rgb = Color.HSBtoRGB(hue, sat, displayBrightness);
                picker.m_84988_(x, y, rgb);
                if (x != crosshairX && y != crosshairY) continue;
            }
        }
    }

    private void renderBrightness() {
        NativeImage slider = this.slider.m_117991_();
        if (slider == null) {
            return;
        }
        int slidebarX = (int)((float)slider.m_84982_() * this.brightness);
        for (int x = 0; x < slider.m_84982_(); ++x) {
            float brightness = (float)x / (float)slider.m_84982_();
            for (int y = 0; y < slider.m_85084_(); ++y) {
                int rgb = Color.HSBtoRGB(this.hue, this.saturation, brightness);
                slider.m_84988_(x, y, rgb);
                if (x != slidebarX) continue;
            }
        }
    }

    private static int getRGB(float hue, float saturation, float brightness) {
        Color rgb = Color.getHSBColor(hue, saturation, brightness);
        return rgb.getRGB();
    }
}

