/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette.component;

import com.conquestreforged.client.gui.palette.component.PaletteSettings;
import com.conquestreforged.client.gui.palette.component.Style;
import com.conquestreforged.client.gui.palette.shape.Bounds;
import com.conquestreforged.client.gui.palette.shape.Point;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PaletteSlot
extends Slot {
    private static final ResourceLocation SLOT = new ResourceLocation("conquest:textures/gui/picker/slot.png");
    private final Style style;
    private final Bounds bounds;

    public PaletteSlot(Container inventory, Style style, Bounds bounds, int index, int x, int y) {
        super(inventory, index, x - 8, y - 8);
        this.style = style;
        this.bounds = bounds;
    }

    public Style getStyle() {
        return this.style;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public boolean isMouseOver(int mx, int my) {
        return mx >= this.f_40220_ - 11 && mx <= this.f_40220_ + 11 && my >= this.f_40221_ - 11 && my <= this.f_40221_ + 11;
    }

    public ResourceLocation getBackground() {
        return SLOT;
    }

    public ItemStack m_7993_() {
        return super.m_7993_().m_41777_();
    }

    public void m_269060_(ItemStack stack) {
    }

    public ItemStack m_6201_(int amount) {
        return this.m_7993_();
    }

    public float getScale(int mx, int my, PaletteSettings settings) {
        if (!this.style.fixedScale) {
            float d2 = Point.distance2(this.f_40220_, this.f_40221_, mx, my);
            float radius = 65.0f;
            float rad2 = radius * radius;
            float alpha = (rad2 - d2) / rad2;
            float scale = this.style.scale;
            if (alpha > 1.0f - settings.zoomSpread) {
                scale += Math.min(Math.max(settings.zoomCurve.apply(alpha) * settings.zoomScale, 0.0f), 2.5f);
            }
            return scale;
        }
        return this.style.scale;
    }
}

