/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.state;

import com.conquestreforged.client.gui.PickerScreen;
import com.conquestreforged.client.gui.render.Render;
import com.conquestreforged.core.item.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateScreen
extends PickerScreen<BlockState> {
    private final Collection<Property<?>> properties;

    public BlockStateScreen(ItemStack stack, BlockState state, List<BlockState> states, Collection<Property<?>> properties) {
        super("State Selector", stack, state, states);
        this.properties = properties;
    }

    @Override
    public boolean match(BlockState a, BlockState b) {
        for (Property<?> property : this.properties) {
            if (a.m_61143_(property).equals(b.m_61143_(property))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public int getYOffset() {
        return -30;
    }

    @Override
    public int getWidth(BlockState option) {
        return 1;
    }

    @Override
    public int getHeight(BlockState option) {
        return 1;
    }

    @Override
    public String getDisplayName(BlockState option) {
        StringBuilder sb = new StringBuilder();
        for (Property<?> property : this.properties) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(property.m_61708_()).append('=').append(option.m_61143_(property));
        }
        return sb.toString();
    }

    @Override
    public void render(BlockState option, GuiGraphics matrixStack, int x, int y, int width, int height, float scale) {
        matrixStack.m_280168_().m_85836_();
        matrixStack.m_280168_().m_252880_((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, 0.0f);
        matrixStack.m_280168_().m_85841_(scale, scale, 1.0f);
        Render.drawBlockModel(matrixStack.m_280168_(), option, -8, -8, 1.0f);
        matrixStack.m_280168_().m_85849_();
    }

    @Override
    public ItemStack createItemStack(ItemStack original, BlockState value) {
        ItemStack stack = ItemUtils.fromState(value, this.properties);
        stack.m_41764_(original.m_41613_());
        return stack;
    }

    public static Optional<BlockStateScreen> of(ItemStack stack, BlockState state, Predicate<Property<?>> filter) {
        HashMap<Property, Comparable> defaults = new HashMap<Property, Comparable>();
        HashSet properties = new HashSet();
        for (Property property : state.m_61147_()) {
            if (filter.test(property)) {
                Comparable defValue = state.m_61143_(property);
                defaults.put(property, defValue);
                continue;
            }
            properties.add(property);
        }
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (BlockState candidate : state.m_60734_().m_49965_().m_61056_()) {
            boolean valid = true;
            for (Map.Entry e : candidate.m_61148_().entrySet()) {
                Object defValue = defaults.get(e.getKey());
                if (defValue == null || defValue.equals(e.getValue())) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            states.add(candidate);
        }
        if (states.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BlockStateScreen(stack, state, states, properties));
    }
}

