/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.models;

import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class DecorBakedModel
extends ForwardingBakedModel {
    public DecorBakedModel(BakedModel baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        BlockState blockStateDown = blockView.m_8055_(pos.m_7495_());
        Float translation = this.computeTranslationAmount(blockStateDown);
        context.pushTransform(quad -> {
            if (translation != null) {
                this.translateDown(quad, translation.floatValue());
            }
            return true;
        });
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private Float computeTranslationAmount(BlockState downState) {
        Block blockDown = downState.m_60734_();
        if (blockDown instanceof SlabBlock && downState.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
            return Float.valueOf(-0.5f);
        }
        if (blockDown instanceof Layer || blockDown instanceof SnowLayerBlock) {
            int layers = (Integer)downState.m_61143_((Property)BlockStateProperties.f_61417_);
            return Float.valueOf(this.getTranslationForStandardLayers(layers));
        }
        if (blockDown instanceof Slab && downState.m_61143_(Slab.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)Slab.LAYERS);
            return Float.valueOf(this.getTranslationForStandardLayers(layers));
        }
        if (blockDown instanceof SlabLessLayers && downState.m_61143_(SlabLessLayers.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)SlabLessLayers.LAYERS);
            return Float.valueOf(this.getTranslationForSlabLessLayers(layers));
        }
        if (blockDown instanceof BoardsHorizontal && downState.m_61143_(com.conquestreforged.content.blocks.block.directional.Half.TYPE_UPDOWN) == Half.BOTTOM) {
            return Float.valueOf(-0.53125f);
        }
        return null;
    }

    private float getTranslationForStandardLayers(int layers) {
        return switch (layers) {
            case 7 -> -0.125f;
            case 6 -> -0.25f;
            case 5 -> -0.375f;
            case 4 -> -0.5f;
            case 3 -> -0.625f;
            case 2 -> -0.75f;
            case 1 -> -0.875f;
            default -> 0.0f;
        };
    }

    private float getTranslationForSlabLessLayers(int layers) {
        return switch (layers) {
            case 4 -> -0.25f;
            case 3 -> -0.5f;
            case 2 -> -0.75f;
            case 1 -> -0.875f;
            default -> 0.0f;
        };
    }

    public void translateDown(MutableQuadView quad, float translationAmount) {
        for (int i = 0; i < 4; ++i) {
            quad.pos(i, quad.x(i), quad.y(i) + translationAmount, quad.z(i));
        }
    }
}

