/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.models;

import com.conquestreforged.content.blocks.block.decor.Loom;
import com.conquestreforged.content.blocks.tileentity.TileEntityTypes;
import com.conquestreforged.content.blocks.tileentity.loom.LoomBlockEntity;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LoomBakedModel
extends ForwardingBakedModel {
    private final BakedModel extraModel;
    private final TextureAtlasSprite[] sprites;

    public LoomBakedModel(BakedModel baseModel, BakedModel extraModel, TextureAtlasSprite[] sprites) {
        this.wrapped = baseModel;
        this.sprites = sprites;
        this.extraModel = extraModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        BlockEntity blockEntity = blockView.m_7702_(pos);
        TextureAtlasSprite sprite = this.sprites[0];
        if (((Boolean)state.m_61143_((Property)Loom.HAS_THREAD)).booleanValue()) {
            List quads;
            if (blockEntity != null && blockEntity.m_58903_() == TileEntityTypes.LOOM) {
                String productData = ((LoomBlockEntity)blockEntity).getProduct();
                int textureVariantIndex = this.getTextureVariant(productData);
                sprite = this.sprites[textureVariantIndex];
            }
            if ((quads = this.m_213637_(state, Direction.UP, randomSupplier.get())).isEmpty() && (quads = this.m_213637_(state, null, randomSupplier.get())).isEmpty()) {
                Direction dir;
                Direction[] textureVariantIndex = Direction.values();
                int n = textureVariantIndex.length;
                for (int i = 0; i < n && (quads = this.m_213637_(state, dir = textureVariantIndex[i], randomSupplier.get())).isEmpty(); ++i) {
                }
            }
            if (!quads.isEmpty()) {
                TextureAtlasSprite originalSprite = ((BakedQuad)quads.get(0)).m_173410_();
                TextureAtlasSprite finalSprite = sprite;
                context.pushTransform(quad -> {
                    float u0 = quad.u(0);
                    float u1 = quad.u(1);
                    float u2 = quad.u(2);
                    float u3 = quad.u(3);
                    float v0 = quad.v(0);
                    float v1 = quad.v(1);
                    float v2 = quad.v(2);
                    float v3 = quad.v(3);
                    float spriteWidth = originalSprite.m_118410_() - originalSprite.m_118409_();
                    float spriteHeight = originalSprite.m_118412_() - originalSprite.m_118411_();
                    float nu0 = (u0 - originalSprite.m_118409_()) / spriteWidth;
                    float nu1 = (u1 - originalSprite.m_118409_()) / spriteWidth;
                    float nu2 = (u2 - originalSprite.m_118409_()) / spriteWidth;
                    float nu3 = (u3 - originalSprite.m_118409_()) / spriteWidth;
                    float nv0 = (v0 - originalSprite.m_118411_()) / spriteHeight;
                    float nv1 = (v1 - originalSprite.m_118411_()) / spriteHeight;
                    float nv2 = (v2 - originalSprite.m_118411_()) / spriteHeight;
                    float nv3 = (v3 - originalSprite.m_118411_()) / spriteHeight;
                    quad.spriteBake(finalSprite, 0);
                    float newU0 = finalSprite.m_118409_() + nu0 * (finalSprite.m_118410_() - finalSprite.m_118409_());
                    float newU1 = finalSprite.m_118409_() + nu1 * (finalSprite.m_118410_() - finalSprite.m_118409_());
                    float newU2 = finalSprite.m_118409_() + nu2 * (finalSprite.m_118410_() - finalSprite.m_118409_());
                    float newU3 = finalSprite.m_118409_() + nu3 * (finalSprite.m_118410_() - finalSprite.m_118409_());
                    float newV0 = finalSprite.m_118411_() + nv0 * (finalSprite.m_118412_() - finalSprite.m_118411_());
                    float newV1 = finalSprite.m_118411_() + nv1 * (finalSprite.m_118412_() - finalSprite.m_118411_());
                    float newV2 = finalSprite.m_118411_() + nv2 * (finalSprite.m_118412_() - finalSprite.m_118411_());
                    float newV3 = finalSprite.m_118411_() + nv3 * (finalSprite.m_118412_() - finalSprite.m_118411_());
                    quad.uv(0, newU0, newV0);
                    quad.uv(1, newU1, newV1);
                    quad.uv(2, newU2, newV2);
                    quad.uv(3, newU3, newV3);
                    return true;
                });
                super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
                context.popTransform();
            } else {
                super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
                context.popTransform();
            }
        }
        context.pushTransform(quad -> true);
        BakedModel originalSprite = this.extraModel;
        if (originalSprite instanceof ForwardingBakedModel) {
            ForwardingBakedModel forwardingModel = (ForwardingBakedModel)originalSprite;
            forwardingModel.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        } else {
            QuadEmitter emitter = context.getEmitter();
            List extraQuads = this.extraModel.m_213637_(state, null, randomSupplier.get());
            for (BakedQuad quad2 : extraQuads) {
                emitter.fromVanilla(quad2, null, null);
                emitter.emit();
            }
            for (Direction direction : Direction.values()) {
                List faceQuads = this.extraModel.m_213637_(state, direction, randomSupplier.get());
                for (BakedQuad quad3 : faceQuads) {
                    emitter.fromVanilla(quad3, null, direction);
                    emitter.emit();
                }
            }
        }
        context.popTransform();
    }

    private int getTextureVariant(String productData) {
        return switch (productData) {
            case "conquest:red_canvas" -> 1;
            case "conquest:black_canvas" -> 2;
            case "conquest:gray_canvas" -> 3;
            case "conquest:light_gray_canvas" -> 4;
            case "conquest:white_canvas" -> 5;
            case "conquest:brown_canvas" -> 6;
            case "conquest:yellow_canvas" -> 7;
            case "conquest:orange_canvas" -> 8;
            case "conquest:pink_canvas" -> 9;
            case "conquest:magenta_canvas" -> 10;
            case "conquest:purple_canvas" -> 11;
            case "conquest:blue_canvas" -> 12;
            case "conquest:light_blue_canvas" -> 13;
            case "conquest:cyan_canvas" -> 14;
            case "conquest:green_canvas" -> 15;
            case "conquest:lime_canvas" -> 16;
            case "conquest:baotuo_rug" -> 17;
            case "conquest:berber_rug" -> 18;
            case "conquest:black_persian_rug" -> 19;
            case "conquest:blue_nain_rug" -> 20;
            case "conquest:brown_oriental_carpet" -> 21;
            case "conquest:celtic_knot_rug" -> 22;
            case "conquest:kashmiri_carpet" -> 23;
            case "conquest:kazakh_rug" -> 24;
            case "conquest:kilim_rug" -> 25;
            case "conquest:nahavand_rug" -> 26;
            case "conquest:red_and_blue_sarouk_rug" -> 27;
            case "conquest:red_oriental_carpet" -> 28;
            case "conquest:red_pazyryk_rug" -> 29;
            case "conquest:shirishabad_rug" -> 30;
            case "conquest:william_morris_rug" -> 31;
            case "conquest:yellow_red_persian_rug" -> 32;
            default -> 0;
        };
    }
}

