/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class TextUtils {
    public static void wrapComplexTextToList(Component text, Font textRenderer, int maxWidth, List<Component> resultList) {
        ArrayList segments = new ArrayList();
        text.m_7451_((style, string) -> {
            segments.add(new StyledTextSegment(string, style));
            return Optional.empty();
        }, Style.f_131099_);
        MutableComponent currentLine = Component.m_237113_((String)"");
        int currentLineWidth = 0;
        for (StyledTextSegment segment : segments) {
            String content = segment.text;
            Style style2 = segment.style;
            List<String> words = TextUtils.splitIntoWords(content);
            for (String word : words) {
                int wordWidth = TextUtils.getWidth(word, textRenderer, style2);
                if (currentLineWidth + wordWidth > maxWidth) {
                    if (!currentLine.getString().isEmpty()) {
                        resultList.add((Component)currentLine);
                        currentLine = Component.m_237113_((String)"");
                        currentLineWidth = 0;
                    }
                    if (wordWidth > maxWidth) {
                        TextUtils.splitLongWord(word, textRenderer, style2, maxWidth, resultList);
                        continue;
                    }
                    currentLine = currentLine.m_7220_((Component)Component.m_237113_((String)word).m_6270_(style2));
                    currentLineWidth = wordWidth;
                    continue;
                }
                currentLine = currentLine.m_7220_((Component)Component.m_237113_((String)word).m_6270_(style2));
                currentLineWidth += wordWidth;
            }
        }
        if (!currentLine.getString().isEmpty()) {
            resultList.add((Component)currentLine);
        }
    }

    private static List<String> splitIntoWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder currentWord = new StringBuilder();
        boolean inWhitespace = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isWhitespace = Character.isWhitespace(c);
            if (isWhitespace != inWhitespace && currentWord.length() > 0) {
                words.add(currentWord.toString());
                currentWord = new StringBuilder();
            }
            currentWord.append(c);
            inWhitespace = isWhitespace;
        }
        if (currentWord.length() > 0) {
            words.add(currentWord.toString());
        }
        return words;
    }

    private static void splitLongWord(String word, Font textRenderer, Style style, int maxWidth, List<Component> resultList) {
        int end;
        for (int start = 0; start < word.length(); start += end) {
            end = TextUtils.findFittingCharacters(word.substring(start), textRenderer, style, maxWidth);
            String part = word.substring(start, start + end);
            resultList.add((Component)Component.m_237113_((String)part).m_6270_(style));
        }
    }

    private static int findFittingCharacters(String text, Font textRenderer, Style style, int maxWidth) {
        if (text.isEmpty()) {
            return 0;
        }
        int low = 0;
        int high = text.length();
        while (low < high) {
            int mid = (low + high + 1) / 2;
            int width = TextUtils.getWidth(text.substring(0, mid), textRenderer, style);
            if (width <= maxWidth) {
                low = mid;
                continue;
            }
            high = mid - 1;
        }
        return Math.max(1, low);
    }

    private static int getWidth(String text, Font textRenderer, Style style) {
        return textRenderer.m_92852_((FormattedText)Component.m_237113_((String)text).m_6270_(style));
    }

    private static class StyledTextSegment {
        public final String text;
        public final Style style;

        public StyledTextSegment(String text, Style style) {
            this.text = text;
            this.style = style;
        }
    }
}

