/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.decor;

import com.conquestreforged.content.blocks.CustomOffsetType;
import com.conquestreforged.content.blocks.block.directional.HorizontalDirectional;
import com.conquestreforged.content.blocks.util.CauldronBehavior;
import com.conquestreforged.core.asset.annotation.Render;
import com.conquestreforged.core.asset.annotation.SpecialOffset;
import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.block.builder.SpecialOffsetType;
import com.conquestreforged.core.util.RenderLayer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Render(value=RenderLayer.CUTOUT)
@SpecialOffset(offsetType=SpecialOffsetType.XYZ)
public class Cauldron
extends Block {
    private final CauldronBehavior behavior;

    public Cauldron(Props props) {
        super(((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true)).toSettings());
        List hitBox = props.get("hitBox", List.class);
        this.behavior = new CauldronBehavior(hitBox);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CauldronBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)CauldronBehavior.OFFSET_TOGGLE)).booleanValue()) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context);
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_().m_122424_();
        Level blockreader = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
        Block block = state.m_60734_();
        boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
        return (BlockState)super.m_5573_(context).m_61124_((Property)CauldronBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.behavior.getOutlineShape(state, world, pos, context);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        this.behavior.onEntityCollision(state, world, pos, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.behavior.onUse(state, level, blockPos, player, hand, hitResult);
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        this.behavior.precipitationTick(state, world, pos, precipitation);
    }

    public boolean m_7278_(BlockState state) {
        return this.behavior.hasComparatorOutput(state);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return this.behavior.getComparatorOutput(state, world, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CauldronBehavior.LEVEL, CauldronBehavior.OFFSET_TOGGLE});
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType navigationType) {
        return false;
    }

    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class CauldronDirectional
    extends HorizontalDirectional {
        private final CauldronBehavior behavior;

        public CauldronDirectional(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            List hitBox = props.get("hitBox", List.class);
            this.behavior = new CauldronBehavior(hitBox);
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CauldronBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            if (((Boolean)state.m_61143_((Property)CauldronBehavior.OFFSET_TOGGLE)).booleanValue()) {
                return this.behavior.getCollisionShape(state, worldIn, pos, context);
            }
            return super.m_5939_(state, worldIn, pos, context);
        }

        @Override
        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)CauldronBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return this.behavior.getOutlineShape(state, world, pos, context);
        }

        public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
            this.behavior.onEntityCollision(state, world, pos, entity);
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.onUse(state, level, blockPos, player, hand, hitResult);
        }

        public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
            this.behavior.precipitationTick(state, world, pos, precipitation);
        }

        public boolean m_7278_(BlockState state) {
            return this.behavior.hasComparatorOutput(state);
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return this.behavior.getComparatorOutput(state, world, pos);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{CauldronBehavior.LEVEL, CauldronBehavior.OFFSET_TOGGLE});
        }

        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType navigationType) {
            return false;
        }
    }
}

