/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.decor;

import com.conquestrefabricated.core.block.properties.ParallelConnectionShape2;
import com.conquestreforged.content.blocks.CustomOffsetType;
import com.conquestreforged.content.blocks.block.decor.TableParallelConnecting;
import com.conquestreforged.content.blocks.block.directional.HorizontalDirectional;
import com.conquestreforged.content.blocks.util.ChairBehavior;
import com.conquestreforged.content.blocks.util.Interactions;
import com.conquestreforged.content.blocks.util.Sittable;
import com.conquestreforged.core.asset.annotation.ItemDescription;
import com.conquestreforged.core.asset.annotation.Render;
import com.conquestreforged.core.asset.annotation.SpecialOffset;
import com.conquestreforged.core.block.base.ShapeBlock;
import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.block.builder.SpecialOffsetType;
import com.conquestreforged.core.util.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Chairs {

    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class WideBench
    extends Bench {
        protected static final VoxelShape SHAPE_FULLPARTIAL = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

        public WideBench(Props props) {
            super(props);
        }

        @Override
        public VoxelShape getShape(BlockState state) {
            return SHAPE_FULLPARTIAL;
        }
    }

    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class Bench
    extends TableParallelConnecting
    implements EntityBlock,
    Sittable {
        protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
        public static final EnumProperty<ParallelConnectionShape2> FORM = EnumProperty.m_61587_((String)"shape", ParallelConnectionShape2.class);
        private final ChairBehavior behavior;

        public Bench(Props props) {
            super(props);
            double chairHeight = props.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(chairHeight);
        }

        @Override
        public double getSeatHeight() {
            return this.behavior.getSeatHeight();
        }

        @Override
        public VoxelShape getShape(BlockState state) {
            return switch ((Direction)state.m_61143_((Property)DIRECTION)) {
                case Direction.EAST, Direction.WEST -> SHAPE_EAST;
                default -> SHAPE_NORTH;
            };
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> super.m_6227_(state, level, blockPos, player, hand, hitResult), null);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }
    }

    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class Toggle6
    extends HorizontalDirectional.Toggle6
    implements EntityBlock,
    Sittable {
        private final ChairBehavior behavior;
        private final double chairHeight;

        public Toggle6(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            this.chairHeight = props.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(props.get("seatHeight", Double.class));
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public double getSeatHeight() {
            return this.chairHeight;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context, super.m_5939_(state, worldIn, pos, context));
        }

        @Override
        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        @Override
        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE), 7);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{ChairBehavior.OFFSET_TOGGLE, TOGGLE});
        }
    }

    @ItemDescription(description="toggle_4")
    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class Toggle4
    extends HorizontalDirectional.Waterlogged.Toggle4
    implements EntityBlock,
    Sittable {
        private final ChairBehavior behavior;
        private final double chairHeight;

        public Toggle4(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            this.chairHeight = props.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(this.chairHeight);
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public double getSeatHeight() {
            return this.chairHeight;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context, super.m_5939_(state, worldIn, pos, context));
        }

        @Override
        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        @Override
        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE), 2);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE, ChairBehavior.OFFSET_TOGGLE});
        }
    }

    @ItemDescription(description="toggle_3")
    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class Toggle3
    extends HorizontalDirectional.Waterlogged.Toggle3
    implements EntityBlock,
    Sittable {
        private final ChairBehavior behavior;
        private final double chairHeight;

        public Toggle3(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            this.chairHeight = props.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(this.chairHeight);
            this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public double getSeatHeight() {
            return this.chairHeight;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context, super.m_5939_(state, worldIn, pos, context));
        }

        @Override
        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        @Override
        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE), 2);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE, ChairBehavior.OFFSET_TOGGLE});
        }
    }

    @ItemDescription(description="toggle_2")
    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class Toggle2
    extends HorizontalDirectional.Waterlogged.Toggle2
    implements EntityBlock,
    Sittable {
        private final ChairBehavior behavior;
        private final double chairHeight;

        public Toggle2(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            this.chairHeight = props.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(this.chairHeight);
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public double getSeatHeight() {
            return this.chairHeight;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context, super.m_5939_(state, worldIn, pos, context));
        }

        @Override
        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        @Override
        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE), 3);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE, ChairBehavior.OFFSET_TOGGLE});
        }
    }

    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class Directional
    extends HorizontalDirectional.Waterlogged
    implements EntityBlock,
    Sittable {
        private final ChairBehavior behavior;

        public Directional(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            double chairHeight = props.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(chairHeight);
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public double getSeatHeight() {
            return this.behavior.getSeatHeight();
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context, super.m_5939_(state, worldIn, pos, context));
        }

        @Override
        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> super.m_6227_(state, level, blockPos, player, hand, hitResult), null);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{ChairBehavior.OFFSET_TOGGLE});
        }
    }

    @Render(value=RenderLayer.CUTOUT)
    @SpecialOffset(offsetType=SpecialOffsetType.Y)
    public static class NonDirectional
    extends ShapeBlock
    implements EntityBlock,
    Sittable {
        private final ChairBehavior behavior;

        public NonDirectional(Props properties) {
            super((Props)((Props)((Props)properties.customOffsetType(CustomOffsetType.LAYER_Y)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            double chairHeight = properties.get("seatHeight", Double.class);
            this.behavior = new ChairBehavior(chairHeight);
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public double getSeatHeight() {
            return this.behavior.getSeatHeight();
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            return this.behavior.getCollisionShape(state, worldIn, pos, context, super.m_5939_(state, worldIn, pos, context));
        }

        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_43719_().m_122424_();
            Level blockreader = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
            Block block = state.m_60734_();
            boolean isSlab = this.behavior.calculateSlabOffset(facing, block, state, context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBehavior.OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return this.behavior.handleSittingInteraction(state, level, blockPos, player, hand, hitResult, () -> super.m_6227_(state, level, blockPos, player, hand, hitResult), null);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return this.behavior.createBlockEntity(blockPos, blockState);
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{ChairBehavior.OFFSET_TOGGLE});
        }
    }
}

