/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.decor;

import com.conquestrefabricated.core.block.properties.ModBlockProperties;
import com.conquestreforged.content.blocks.CustomOffsetType;
import com.conquestreforged.content.blocks.util.Interactions;
import com.conquestreforged.content.blocks.util.PlacementHelper;
import com.conquestreforged.core.asset.annotation.ItemDescription;
import com.conquestreforged.core.asset.annotation.SpecialOffset;
import com.conquestreforged.core.block.base.Shape;
import com.conquestreforged.core.block.base.WaterloggedShape;
import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.block.builder.SpecialOffsetType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ModelBlock
extends Shape {
    private final List<VoxelShape> hitBox;

    public ModelBlock(Props props) {
        super(props.toSettings());
        this.hitBox = props.get("hitBox", List.class);
    }

    @Override
    public VoxelShape getShape(BlockState state) {
        return this.hitBox.get(0);
    }

    @ItemDescription(description="toggle_4")
    public static class Toggle4
    extends Waterlogged {
        public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)4);

        public Toggle4(Props props) {
            super(props);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE});
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
        }
    }

    @ItemDescription(description="toggle_3")
    public static class Toggle3
    extends Waterlogged {
        public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)3);

        public Toggle3(Props props) {
            super(props);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE});
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
        }
    }

    @ItemDescription(description="toggle_2")
    public static class Toggle2
    extends Waterlogged {
        public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)2);

        public Toggle2(Props props) {
            super(props);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE});
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
        }
    }

    @SpecialOffset(offsetType=SpecialOffsetType.XYZ)
    public static class OffsetXYZ
    extends OffsetY {
        public OffsetXYZ(Props props) {
            super((Props)props.customOffsetType(CustomOffsetType.LAYER_XYZ));
        }
    }

    @SpecialOffset(offsetType=SpecialOffsetType.Y)
    public static class OffsetY
    extends ModelBlock {
        public static final BooleanProperty OFFSET_TOGGLE = ModBlockProperties.OFFSET_TOGGLE;

        public OffsetY(Props props) {
            super((Props)((Props)((Props)props.customOffsetType(CustomOffsetType.LAYER_Y)).offset(BlockBehaviour.OffsetType.NONE)).dynamicBounds(true));
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            if (((Boolean)state.m_61143_((Property)OFFSET_TOGGLE)).booleanValue()) {
                return Shapes.m_83040_();
            }
            return super.m_5939_(state, worldIn, pos, context);
        }

        @NotNull
        public BlockState m_5573_(BlockPlaceContext context) {
            boolean isSlab = PlacementHelper.isFacingSlab(context);
            return (BlockState)super.m_5573_(context).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
        }

        protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{OFFSET_TOGGLE});
        }
    }

    public static class Waterlogged
    extends WaterloggedShape {
        private final List<VoxelShape> hitBox;

        public Waterlogged(Props props) {
            super(props.toSettings());
            this.hitBox = props.get("hitBox", List.class);
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public VoxelShape getShape(BlockState state) {
            return this.hitBox.get(0);
        }
    }
}

